/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.LineLocation;

public class LineLocationImpl
implements LineLocation {
    private final String desc;
    private final int position;
    private final LineLocation parent;

    public String toString() {
        if (this.desc == null) {
            return "[?] : " + this.position;
        }
        return this.desc + " : " + this.position;
    }

    public LineLocationImpl(String string, LineLocation lineLocation) {
        this(string, lineLocation, -1);
    }

    private LineLocationImpl(String string, LineLocation lineLocation, int n) {
        this.parent = lineLocation;
        this.desc = string;
        this.position = n;
    }

    public LineLocationImpl oneLineRead() {
        return new LineLocationImpl(this.desc, this.parent, this.position + 1);
    }

    public static LineLocation fromLine(CharSequence charSequence) {
        if (charSequence instanceof CharSequence2) {
            return ((CharSequence2)charSequence).getLocation();
        }
        return null;
    }

    public int getPosition() {
        return this.position;
    }

    public String getDescription() {
        return this.desc;
    }

    public LineLocation getParent() {
        return this.parent;
    }

    public int compareTo(LineLocation lineLocation) {
        LineLocationImpl lineLocationImpl = (LineLocationImpl)lineLocation;
        return this.position - lineLocationImpl.position;
    }
}

