/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.braille.BrailleCharFactory;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileFormat {
    PNG,
    SVG,
    EPS,
    EPS_TEXT,
    ATXT,
    UTXT,
    XMI_STANDARD,
    XMI_STAR,
    XMI_ARGO,
    SCXML,
    PDF,
    MJPEG,
    ANIMATED_GIF,
    HTML,
    HTML5,
    VDX,
    LATEX,
    LATEX_NO_PREAMBLE,
    BASE64,
    BRAILLE_PNG;

    private static final BufferedImage imDummy;
    private static final Graphics2D gg;

    public String getFileSuffix() {
        if (this.name().startsWith("XMI")) {
            return ".xmi";
        }
        if (this == MJPEG) {
            return ".avi";
        }
        if (this == LATEX_NO_PREAMBLE) {
            return ".latex";
        }
        if (this == ANIMATED_GIF) {
            return ".gif";
        }
        if (this == BRAILLE_PNG) {
            return ".braille.png";
        }
        if (this == EPS_TEXT) {
            return EPS.getFileSuffix();
        }
        return "." + StringUtils.goLowerCase(this.name());
    }

    public StringBounder getDefaultStringBounder() {
        if (this == BRAILLE_PNG) {
            return new StringBounder(){

                public Dimension2D calculateDimension(UFont uFont, String string) {
                    int n = BrailleCharFactory.build(string).size();
                    double d = (double)(3 * n) * 4.0 + 1.0;
                    return new Dimension2DDouble(d, 20.0);
                }
            };
        }
        return new StringBounder(){

            public Dimension2D calculateDimension(UFont uFont, String string) {
                FontMetrics fontMetrics = gg.getFontMetrics(uFont.getFont());
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, gg);
                return new Dimension2DDouble(rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        };
    }

    public boolean isEps() {
        if (this == EPS) {
            return true;
        }
        return this == EPS_TEXT;
    }

    public String changeName(String string, int n) {
        if (n == 0) {
            return this.changeName(string, this.getFileSuffix());
        }
        return this.changeName(string, OptionFlags.getInstance().getFileSeparator() + String.format("%03d", n) + this.getFileSuffix());
    }

    private File computeFilename(File file, int n) {
        if (n == 0) {
            return file;
        }
        File file2 = file.getParentFile();
        return new File(file2, this.computeFilenameInternal(file.getName(), n));
    }

    private String changeName(String string, String string2) {
        String string3 = string.replaceAll("\\.\\w+$", string2);
        if (string3.equals(string)) {
            string3 = string + string2;
        }
        return string3;
    }

    private String computeFilenameInternal(String string, int n) {
        if (n == 0) {
            return string;
        }
        return string.replaceAll("\\" + this.getFileSuffix() + "$", OptionFlags.getInstance().getFileSeparator() + String.format("%03d", n) + this.getFileSuffix());
    }

    static {
        imDummy = new BufferedImage(800, 100, 1);
        gg = imDummy.createGraphics();
    }
}

