/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;

public class BaseFile {
    private final String basename;
    private final File basedir;

    public BaseFile() {
        this.basedir = null;
        this.basename = null;
    }

    public BaseFile(File file) {
        this.basedir = file.getParentFile();
        this.basename = BaseFile.extractBasename(file.getName());
    }

    private static String extractBasename(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String toString() {
        if (this.basedir == null || this.basename == null) {
            return "(DEFAULT)";
        }
        return this.basedir + " " + this.basename;
    }

    public String getBasename() {
        return this.basename;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public File getTraceFile(String string) {
        if (this.basedir == null || this.basename == null) {
            return new File(string);
        }
        return new File(this.basedir, this.basename + "_" + string);
    }
}

