/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ProtectedCommand;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.stats.StatsUtilsIncrement;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.Version;

public abstract class AbstractPSystem
implements Diagram {
    private UmlSource source;

    private String getVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PlantUML version ");
        stringBuilder.append(Version.versionString());
        stringBuilder.append("(" + Version.compileTimeString() + ")\n");
        stringBuilder.append("(" + (Object)((Object)License.getCurrent()) + " source distribution)\n");
        for (String string : OptionPrint.interestingProperties()) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public final String getMetadata() {
        if (this.source == null) {
            return this.getVersion();
        }
        return this.source.getPlainString() + "\n" + this.getVersion();
    }

    public final UmlSource getSource() {
        return this.source;
    }

    public final long seed() {
        if (this.source == null) {
            return 42L;
        }
        return this.getSource().seed();
    }

    public final void setSource(UmlSource umlSource) {
        this.source = umlSource;
    }

    public int getNbImages() {
        return 1;
    }

    public DisplayPositionned getTitle() {
        if (this.source == null) {
            return new DisplayPositionned(Display.empty(), HorizontalAlignment.CENTER, VerticalAlignment.TOP);
        }
        return new DisplayPositionned(this.source.getTitle(), HorizontalAlignment.CENTER, VerticalAlignment.TOP);
    }

    public String getWarningOrError() {
        return null;
    }

    public String checkFinalError() {
        return null;
    }

    public void makeDiagramReady() {
    }

    public boolean isOk() {
        return true;
    }

    public CommandExecutionResult executeCommand(Command protectedCommand, BlocLines blocLines) {
        protectedCommand = new ProtectedCommand(protectedCommand);
        return protectedCommand.execute(this, blocLines);
    }

    public boolean hasUrl() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        long l = System.currentTimeMillis();
        try {
            ImageData imageData = this.exportDiagramNow(outputStream, n, fileFormatOption, this.seed());
            return imageData;
        }
        finally {
            if (OptionFlags.getInstance().isEnableStats()) {
                StatsUtilsIncrement.onceMoreGenerate(System.currentTimeMillis() - l, this.getClass(), fileFormatOption.getFileFormat());
            }
        }
    }

    protected abstract ImageData exportDiagramNow(OutputStream var1, int var2, FileFormatOption var3, long var4) throws IOException;
}

