/*
 * Decompiled with CFR 0.152.
 */
package czlab.wabbit;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CljPodLoader
extends URLClassLoader {
    public static final Logger TLOG = LoggerFactory.getLogger(CljPodLoader.class);
    private final Set<String> _exts = new HashSet<String>();
    private final List<ClassFileTransformer> _transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private final ClassLoader _parent = this.getParent();
    private boolean _loaded;

    public static CljPodLoader newInstance(File file, File file2) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
        CljPodLoader cljPodLoader = new CljPodLoader(classLoader == null ? classLoader2 : classLoader);
        cljPodLoader.init(file, file2);
        return cljPodLoader;
    }

    private CljPodLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        if (this._parent == null) {
            throw new IllegalArgumentException("no parent classloader");
        }
        this._exts.add(".jar");
        this._exts.add(".zip");
    }

    private boolean isFileSupported(String string) {
        int n = string.lastIndexOf(46);
        return n >= 0 && this._exts.contains(string.substring(n));
    }

    private boolean isSystem(String string) {
        if (string != null) {
            return string.startsWith("org.xml.sax.") || string.startsWith("org.w3c.dom.") || string.startsWith("com.sun.") || string.startsWith("sun.") || string.startsWith("javax.") || string.startsWith("java.") || string.startsWith("org/xml/sax/") || string.startsWith("org/w3c/dom/") || string.startsWith("com/sun/") || string.startsWith("sun/") || string.startsWith("javax/") || string.startsWith("java/");
        }
        return false;
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        boolean bl = this.isSystem(string);
        Enumeration<URL> enumeration = !bl ? null : this._parent.getResources(string);
        Enumeration<URL> enumeration2 = bl && !enumeration.hasMoreElements() ? null : this.findResources(string);
        List<URL> list = this.toList(enumeration2);
        list.addAll(this.toList(enumeration));
        return Collections.enumeration(list);
    }

    private List<URL> toList(Enumeration<URL> enumeration) {
        return enumeration == null ? new ArrayList<URL>() : Collections.list(enumeration);
    }

    @Override
    public URL getResource(String string) {
        boolean bl = false;
        boolean bl2 = this.isSystem(string);
        ClassLoader classLoader = null;
        URL uRL = null;
        if (this._parent != null && bl2) {
            bl = true;
            classLoader = this._parent;
            uRL = this._parent.getResource(string);
        }
        if (uRL == null) {
            uRL = this.findResource(string);
            classLoader = this;
            if (uRL == null && string.startsWith("/")) {
                uRL = this.findResource(string.substring(1));
            }
        }
        if (uRL == null && !bl && bl2 && this._parent != null) {
            bl = true;
            classLoader = this._parent;
            uRL = this._parent.getResource(string);
        }
        return uRL;
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(string);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass(string);
            ClassNotFoundException classNotFoundException = null;
            boolean bl2 = false;
            boolean bl3 = this.isSystem(string);
            ClassLoader classLoader = null;
            if (clazz == null && this._parent != null && bl3) {
                bl2 = true;
                classLoader = this._parent;
                try {
                    clazz = this._parent.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    classNotFoundException = classNotFoundException2;
                }
            }
            if (clazz == null) {
                try {
                    classLoader = this;
                    clazz = this.findClass(string);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    classNotFoundException = classNotFoundException3;
                }
            }
            if (clazz == null && this._parent != null && !bl2 && bl3) {
                bl2 = true;
                classLoader = this._parent;
                clazz = this._parent.loadClass(string);
            }
            if (clazz == null && classNotFoundException != null) {
                throw classNotFoundException;
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        this._transformers.add(classFileTransformer);
    }

    public boolean removeTransformer(ClassFileTransformer classFileTransformer) {
        return this._transformers.remove(classFileTransformer);
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this._transformers.isEmpty()) {
            clazz = super.findClass(string);
        } else {
            String string2 = string.replace('.', '/').concat(".class");
            URL uRL = this.getResource(string2);
            if (uRL == null) {
                throw new ClassNotFoundException(string);
            }
            try (InputStream inputStream = uRL.openStream();){
                byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                for (ClassFileTransformer classFileTransformer : this._transformers) {
                    byte[] byArray2 = classFileTransformer.transform(this, string, null, null, byArray);
                    if (byArray2 == null) continue;
                    byArray = byArray2;
                }
                clazz = this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string, iOException);
            }
            catch (IllegalClassFormatException illegalClassFormatException) {
                throw new ClassNotFoundException(string, illegalClassFormatException);
            }
        }
        return clazz;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        return "CljPodLoader@" + Long.toHexString(this.hashCode());
    }

    private void init0(File file) {
        File file2 = new File(file, "patch");
        File file3 = new File(file, "lib");
        File file4 = new File(file, "dist");
        this.findUrls(file2).findUrls(file4).findUrls(file3);
    }

    private CljPodLoader init(File file, File file2) {
        File file3 = new File(file2, "src/main/clojure");
        File file4 = new File(file2, "out/classes");
        File file5 = new File(file2, "patch");
        File file6 = new File(file2, "lib");
        if (!this._loaded) {
            this.findUrls(file5);
            this.addUrl(file4);
            this.findUrls(file6);
            this.init0(file);
        }
        this._loaded = true;
        return this;
    }

    private CljPodLoader findUrls(File file) {
        if (file.exists()) {
            file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    if (string.endsWith(".jar")) {
                        CljPodLoader.this.addUrl(new File(file, string));
                    }
                    return false;
                }
            });
        }
        return this;
    }

    private CljPodLoader addUrl(File file) {
        if (file.exists()) {
            try {
                this.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        return this;
    }

    static {
        CljPodLoader.registerAsParallelCapable();
    }
}

