/*
 * Decompiled with CFR 0.152.
 */
package czlab.nettio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.concurrent.EventExecutor;

public class CPAggregator
extends DefaultChannelPromise {
    private final ChannelPromise promise;
    private int expectedCount;
    private int doneCount;
    private Throwable lastFailure;
    private boolean doneAllocating;

    public CPAggregator(ChannelPromise channelPromise, Channel channel, EventExecutor eventExecutor) {
        super(channel, eventExecutor);
        assert (channelPromise != null && !channelPromise.isDone());
        this.promise = channelPromise;
    }

    public ChannelPromise newPromise() {
        assert (!this.doneAllocating) : "Done allocating. No more promises can be allocated.";
        ++this.expectedCount;
        return this;
    }

    public ChannelPromise doneAllocatingPromises() {
        if (!this.doneAllocating) {
            this.doneAllocating = true;
            if (this.doneCount == this.expectedCount || this.expectedCount == 0) {
                return this.setPromise();
            }
        }
        return this;
    }

    public boolean tryFailure(Throwable throwable) {
        if (this.allowFailure()) {
            ++this.doneCount;
            this.lastFailure = throwable;
            if (this.allPromisesDone()) {
                return this.tryPromise();
            }
            return true;
        }
        return false;
    }

    public ChannelPromise setFailure(Throwable throwable) {
        if (this.allowFailure()) {
            ++this.doneCount;
            this.lastFailure = throwable;
            if (this.allPromisesDone()) {
                return this.setPromise();
            }
        }
        return this;
    }

    public ChannelPromise setSuccess(Void void_) {
        if (this.awaitingPromises()) {
            ++this.doneCount;
            if (this.allPromisesDone()) {
                this.setPromise();
            }
        }
        return this;
    }

    public boolean trySuccess(Void void_) {
        if (this.awaitingPromises()) {
            ++this.doneCount;
            if (this.allPromisesDone()) {
                return this.tryPromise();
            }
            return true;
        }
        return false;
    }

    private boolean allowFailure() {
        return this.awaitingPromises() || this.expectedCount == 0;
    }

    private boolean awaitingPromises() {
        return this.doneCount < this.expectedCount;
    }

    private boolean allPromisesDone() {
        return this.doneCount == this.expectedCount && this.doneAllocating;
    }

    private ChannelPromise setPromise() {
        if (this.lastFailure == null) {
            this.promise.setSuccess();
            return super.setSuccess(null);
        }
        this.promise.setFailure(this.lastFailure);
        return super.setFailure(this.lastFailure);
    }

    private boolean tryPromise() {
        if (this.lastFailure == null) {
            this.promise.trySuccess();
            return super.trySuccess(null);
        }
        this.promise.tryFailure(this.lastFailure);
        return super.tryFailure(this.lastFailure);
    }
}

