/*
 * Decompiled with CFR 0.152.
 */
package czlab.nettio;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class InboundHandler
extends ChannelInboundHandlerAdapter {
    public static final Logger TLOG = LoggerFactory.getLogger(InboundHandler.class);
    private boolean _rel;

    protected InboundHandler(boolean bl) {
        this._rel = bl;
    }

    protected InboundHandler() {
        this(false);
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelActive(channelHandlerContext);
        this.onActive(channelHandlerContext);
    }

    public void readMsg(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
    }

    public void onWriteChanged(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    public void onInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    public void onActive(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    public void onUnreg(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    public void onReg(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelInactive(channelHandlerContext);
        this.onInactive(channelHandlerContext);
    }

    public void channelRegistered(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelRegistered(channelHandlerContext);
        this.onReg(channelHandlerContext);
    }

    public void channelUnregistered(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelUnregistered(channelHandlerContext);
        this.onUnreg(channelHandlerContext);
    }

    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelWritabilityChanged(channelHandlerContext);
        this.onWriteChanged(channelHandlerContext);
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        TLOG.error("", throwable);
        channelHandlerContext.channel().close();
    }

    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        TLOG.debug("user-event-triggered: {}", object != null ? object : "null");
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        try {
            this.readMsg(channelHandlerContext, object);
        }
        finally {
            if (this._rel) {
                ReferenceCountUtil.release((Object)object);
            }
        }
    }
}

