/*
 * Decompiled with CFR 0.152.
 */
package czlab.jasal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public enum DateUtil {

    private static ThreadLocal<SimpleDateFormat> _fmt = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return simpleDateFormat;
        }
    };

    public static long parseHttpDate(String string, long l) {
        try {
            return DateUtil.parseHttpDate(string);
        }
        catch (ParseException parseException) {
            return l;
        }
    }

    public static long parseHttpDate(String string) throws ParseException {
        return DateUtil.getSDF().parse(string).getTime();
    }

    public static String formatHttpDate(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.setTimeInMillis(l);
        return DateUtil.getSDF().format(gregorianCalendar.getTime());
    }

    public static String formatHttpDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.setTime(date);
        return DateUtil.getSDF().format(gregorianCalendar.getTime());
    }

    public static SimpleDateFormat getSDF() {
        return _fmt.get();
    }
}

