(ns io.cvcf.frag.u.urls
  (:require
   [clojure.string :as str]
   [io.cvcf.frag.u.names :refer [>name]]))

(defn social [platform profile]
  (letfn [(youtube? [p] (= (str/lower-case (>name p)) "youtube"))]
    (cond-> (str "https://" (>name platform) ".com/")
      (youtube? platform) (str "@")
      :else               (str (>name profile)))))
