(ns io.cvcf.frag.u.datetime)

(defn now
  []
  #?(:clj  (java.time.LocalDateTime/now)
     :cljs (js/Date.)))

(defn year
  ([]   (year (now)))
  ([dt] #?(:clj  (.getYear dt)
           :cljs (.getFullYear dt))))

(defn year-range
  [{:keys [beg end] :or {beg :current end :current}}]
  (let [curr? #(#{:curr :current} %)
        get-year #(if (curr? %) (year) %)]
    (sort < #{(get-year beg) (get-year end)})))
