(ns io.cvcf.frag.scenes.images
  (:require
   [io.cvcf.frag.core :as f]
   [portfolio.replicant :as p :refer-macros [defscene]]))

(p/configure-scenes
 {:title "Image Components"})

(defscene image
  (f/render
   {:type :comp/box
    :children
    [{:type :comp/image
      :src  "/img/test.png"
      :alt  "Logo"}
     {:type :comp/image
      :src "/img/test.png"
      :alt "Logo"
      :text {:value "Some text"}}
     {:type :comp/image
      :src "/img/test.png"
      :alt "Logo"
      :text {:value "Some text"
             :bg "bg-blue-400"
             :fg "text-orange-600"}}]}))

(defscene image-link
  (f/render
   {:type  :comp/link
    :href  "/"
    :label {:type :comp/image :src "/img/test.png" :alt "Test Image"}}))

(defscene hero
  (f/render
   {:type :comp/box
    :class ["flex" "flex-col" "space-y-4"]
    :children
    [{:type :comp/hero
      :image {:src "/img/test.png"}
      :title "The Title"
      :subtitle "The subtitle"}
     {:type :comp/hero
      :image {:src "/img/test.png"}
      :title "The Title"}]}))

(defscene carousel-single-image
  :params (atom {:index 0})
  [params _portfolio-opts]
  (f/render
   {:type :comp/carousel
    :index (:index @params)
    :children
    [{:type :comp/image
      :src "/img/test.png"}]}))

(defscene carousel-multi-image
  :params (atom {:index 0 :total 5})
  [params _portfolio-opts]
  (let [{:keys [total index]} @params]
    (f/render
     {:type :comp/carousel
      :f/carousel-wrapper {:css {:extra ["test"]}}
      :index index
      :buttons {:left  {:click [[:carousel/prev params]]
                        :css {:extra ["test" "one"]}}
                :right {:click [[:carousel/next params]]
                        :css {:extra ["test" "two"]}}}
      :children
      (map (fn [i]
             {:type :comp/image
              :src (str "https://placehold.co/200/png?text=Test+" i)
              :alt (str "Test " i)})
           (range total))})))
