(ns io.cvcf.frag.scenes.basic
  (:require
   [io.cvcf.frag.core :as f]
   [portfolio.replicant :as p :refer-macros [defscene]]))

(p/configure-scenes
 {:title "Basic Components"})

(defscene boxes
  (f/render
   {:type :comp/box
    :class ["flex-col"]
    :children
    [{:type :comp/box
      :children
      [{:type :comp/heading :importance 2 :text "A heading"}
       {:type :comp/text :text "some text"}]}
     {:type :comp/box
      :children
      [{:type :comp/heading :importance 2 :text "A heading"}
       {:type :comp/box
        :children
        [{:type :comp/text :text "some text"}
         {:type :comp/image :src "/img/test.png"}]}]}]}))

(defscene links
  (f/render
   {:type :comp/box
    :children
    [{:type  :comp/link
      :href  "/"
      :label "Home"}
     {:type  :comp/link
      :style :email
      :href  "me@email.com"
      :label "me@email.com"}
     {:type  :comp/link
      :style :tel
      :href  "+1.234.567.8900"
      :label "+1.234.567.8900"}
     {:type :comp/link
      :style :social
      :platform :github
      :profile "clojure"
      :label "clojure"}]}))

(defscene menu
  (f/render
   {:type  :comp/links
    :id    :id/primary
    :children
    (mapv (fn [label]
            {:type  :comp/link
             :href  (str "/" label)
             :label label})
          ["first" "second" "third"])}))

(defscene copyright-statements
  (f/render
   {:type :comp/box
    :class ["flex" "flex-col"]
    :children
    [{:type :comp/copyright :end 2023}
     {:type :comp/copyright :beg 2020 :end 2023}
     {:type :comp/copyright :beg 2018 :end :current}]}))

(defscene headings
  [:div
   (map (fn [i]
          (f/render
           {:type :comp/heading
            :importance i
            :text (str "Heading " i)}))
        (range 1 7))])

(defscene address
  (f/render
   {:type :comp/box
    :class ["flex-col"]
    :children
    [{:type    :comp/address
      :street1 "123 Main St"
      :city    "Anycity"
      :state   "Anystate"
      :zip     "87654"
      :country "USA"}
     {:type    :comp/address
      :street1 "123 Main St"
      :street2 "Apt 42"
      :city    "Anycity"
      :state   "Anystate"
      :zip     "87654"
      :country "USA"}]}))

(defscene paragraphs
  (f/render
   {:type :comp/box
    :class ["flex-col"]
    :children
    [{:type :comp/text
      :text "Aliquam posuere.  Phasellus neque orci, porta a, aliquet."}
     {:type :comp/text
      :text
      ["Aliquam posuere.  Phasellus neque orci, porta a, aliquet."]}
     {:type :comp/text
      :sep  " "
      :text
      ["Aliquam posuere.  Phasellus neque orci, porta a,"
       "aliquet quis, semper a, massa.  Curabitur vulputate"
       "vestibulum lorem.  Vestibulum convallis, lorem a tempus"
       "semper, dui dui euismod elit, vitae placerat urna tortor"
       "vitae lacus."]}
     {:type :comp/text
      :id "test"
      :class ["my-4"]
      :text
      ["Aliquam posuere.  Phasellus neque orci, porta a,"
       "aliquet quis, semper a, massa.  Curabitur vulputate"
       "vestibulum lorem.  Vestibulum convallis, lorem a tempus"
       "semper, dui dui euismod elit, vitae placerat urna tortor"
       "vitae lacus."]}
     {:type :comp/text
      :sep  [:br]
      :text
      ["Aliquam posuere.  Phasellus neque orci, porta a,"
       "aliquet quis, semper a, massa.  Curabitur vulputate"
       "vestibulum lorem.  Vestibulum convallis, lorem a tempus"
       "semper, dui dui euismod elit, vitae placerat urna tortor"
       "vitae lacus."]}]}))

(defscene social
  (f/render
   {:type :comp/box
    :children
    [{:type :comp/social :platform :facebook :profile :test}
     {:type :comp/social :platform "github" :profile "clojure"}]}))

(defscene lists
  (let [items (map (fn [i] {:type :comp/list-item :value i}) (range 3))]
    (f/render
     {:type :comp/box
      :class ["flex-col"]
      :children
      [{:type :comp/list :style :ordered :children items}
       {:type :comp/list :style :unordered :children items}]})))
