(ns io.cvcf.frag.inputs
  (:require
   [io.cvcf.frag.core :refer [render]]
   [io.cvcf.frag.css :refer [>css]]
   [io.cvcf.frag.u.names :refer [>id >name]]))

(defn input
  [{:keys [id required? placeholder value on]
    ctype :type
    cname :name
    :as opts}]
  [:input
   {:id (>id id)
    :type (>name ctype)
    :name (>name cname)
    :required required?
    :placeholder placeholder
    :value value
    :class (>css opts)
    :on on}])

(defmethod render :input/text
  [{:keys [tabindex autocomplete dirname disabled form maxlength minlength pattern size]
    clist :list
    :as opts}]
  (let [[tag attrs] (input opts)
        text-attrs {:tabindex tabindex
                    :autocomplete autocomplete
                    :dirname dirname
                    :disabled disabled
                    :form form
                    :maxlength maxlength
                    :minlength minlength
                    :pattern pattern
                    :size size
                    :list clist}]
    [tag (merge attrs text-attrs)]))

(defmethod render :input/email  [opts] (input opts))
(defmethod render :input/tel    [opts] (input opts))
(defmethod render :input/submit [opts] (input opts))
(defmethod render :input/hidden [opts] (input opts))
(defmethod render :input/longtext
  [{:keys [id required? placeholder on] cname :name :as opts}]
  [:textarea
   {:id (>id id)
    :name cname
    :required required?
    :placeholder placeholder
    :class (>css opts)
    :on on}])

(defmethod render :input/select
  [{:keys [id required? children on] cname :name :as opts}]
  (into
   [:select
    {:id (>id id)
     :name (>name cname)
     :class (>css opts)
     :required required?
     :on on}]
   (map (fn [c] [:option {:value c} c]) children)))
