(ns io.cvcf.frag.images
  (:require
   [io.cvcf.frag.core :refer [render]]
   [io.cvcf.frag.css :refer [>css]]
   [io.cvcf.frag.u.names :refer [>id]]))

(defmethod render :comp/image
  [{:keys [id src alt text on] :as opts}]
  (render
   {:type :comp/box
    :class (>css {:type :f/image-wrapper})
    :children
    (concat
     [{:type :f/value
       :value
       [:img
        {:id (>id id) :src src :alt alt :class (>css opts) :on on}]}]
     (when-let [{:keys [value]} text]
       [{:type :comp/box
         :class (>css (merge {:type :f/image-text} text))
         :children
         [{:type :comp/heading :importance 6 :text value}]}]))}))

(defmethod render :comp/hero
  [{:keys [id image title subtitle on] :as opts}]
  (render
   {:type :comp/box
    :id id :class (>css {:type :f/hero-wrapper}) :on on
    :styles {:background-image (str "url(" (:src image) ")")}
    :children
    [{:type :comp/empty :class (>css {:type :f/hero-overlay})}
     {:type :comp/box
      :class (>css opts)
      :children
      [{:type :comp/box
        :class (>css {:type :f/hero-image})
        :children
        (concat
         [{:type :comp/heading :importance 4 :text title}]
         (when subtitle
           [{:type :comp/heading
             :importance 5
             :class (>css {:type :f/hero-text})
             :text subtitle}]))}]}]}))

(defmethod render :comp/carousel-button
  [{:keys [on value css] :as opts}]
  [:button {:class (>css opts (:extra css)) :on on}
   (render {:type :f/value :value value})])

(defmethod render :comp/carousel
  [{:keys [id children index buttons on] :as opts}]
  (let [total (count children)]
    (render
     {:type :comp/box
      :class (let [{:keys [f/carousel-wrapper]} opts]
               (>css :f/carousel-wrapper
                     (get-in carousel-wrapper [:css :class])
                     (get-in carousel-wrapper [:css :extra])))
      :children
      (concat
       [{:type :comp/box
         :id id :class (>css opts) :on on
         :children [(nth children index)]}]
       (when (> total 1)
         (let [{:keys [fg bg left right]} buttons]
           [{:type :comp/carousel-button
             :direction :left
             :fg fg :bg bg
             :on {:click (:click left)}
             :css {:extra (get-in left [:css :extra])}
             :value (:value left "‹")}
            {:type :comp/carousel-button
             :direction :right
             :fg fg :bg bg
             :on {:click (:click right)}
             :css {:extra (get-in right [:css :extra])}
             :value (:value right "›")}])))})))
