(ns io.cvcf.frag.forms
  (:require
   [io.cvcf.frag.core :refer [render]]
   [io.cvcf.frag.u.names :refer [>id]]
   [io.cvcf.frag.css :refer [>css]]))

(defmethod render :comp/form
  [{:keys [id url method children on]
    :as   opts
    :or   {method "get"}}]
  [:form
   {:id (>id id)
    :class (>css opts)
    :action url
    :method method
    :on on}
   (render {:type :comp/children :children children})])

(defmethod render :form/field
  [{:keys [id label required? input children placeholder on
           label-class input-class]
    cname :name
    :as   opts}]
  (render
   {:type :comp/box
    :id (>id id)
    :class (>css opts)
    :on on
    :children
    [{:type :form/label
      :text label
      :name cname
      :required? required?
      :class (>css {:type :form/label} label-class)}
     {:type input
      :name cname
      :required? required?
      :placeholder placeholder
      :children children
      :class (>css {:type input} input-class)}]}))

(defmethod render :form/label
  [{:keys [id text required? on] cname :name :as opts}]
  [:label {:id (>id id) :for cname :class (>css opts) :on on}
   text
   (when required?
     [:abbr {:title "Required!"} "*"])])
