(ns io.cvcf.frag.css
  (:require
   [io.cvcf.frag.u.names :refer [>name]]))

(def ^:const default-fg "text-white")
(def ^:const default-bg "bg-black")

(defmulti css :type)

(defn >css
  ([type class extra] (>css {:type type :class class :extra extra}))
  ([opts extra]       (>css (merge opts {:extra extra})))
  ([opts]             (concat (or (:class opts) (css opts))
                              (:extra opts))))

(defmethod css :comp/image
  [_]
  ["rounded-lg"])

(defmethod css :comp/empty
  [_]
  [])

(defmethod css :f/image-wrapper
  [_]
  ["relative" "mx-auto"])

(defmethod css :f/image-text
  [{:keys [fg bg] :or {fg default-fg bg default-bg}}]
  ["absolute" "bottom-4" "left-4"
   "py-2" "px-4" "rounded-xl"
   fg bg "bg-opacity-50"])

(defmethod css :comp/link
  [_]
  ["py-2" "px-4" "font-semibold" "hover:underline"])

(defmethod css :comp/links
  [_]
  ["flex" "flex-col" "items-center" "md:flex-row"])

(defmethod css :comp/copyright
  [_]
  ["font-semibold"])

(defmethod css :comp/heading
  [{:keys [importance]}]
  (case importance
    1 ["font-bold" "text-6xl"]
    2 ["font-bold" "text-5xl"]
    3 ["font-semibold" "text-4xl"]
    4 ["font-semibold" "text-3xl"]
    5 ["font-semibold" "text-2xl"]
    6 ["text-xl"]))

(defmethod css :comp/address
  [_]
  ["my" "italic"])

(defmethod css :comp/text
  [_]
  ["py-4"])

(defmethod css :comp/box
  [_]
  ["flex" "flex-col" "md:flex-row"])

(defmethod css :comp/social
  [{:keys [platform]}]
  (concat
   ["fa-brands" "fa-xl"]
   (when platform
     [(str "fa-" (>name platform))])))

(defmethod css :comp/list
  [{:keys [style]}]
  ["my-3"
   "list-inside"
   (case style
     :ordered   "list-decimal"
     :unordered "list-disc"
     "list-none")])

(defmethod css :comp/list-item
  [_]
  [])

(defmethod css :comp/hero
  [_]
  ["relative" "z-10" "px-4" "flex" "flex-col"
   "items-start" "justify-end" "h-full" "text-center"])

(defmethod css :f/hero-wrapper
  [_]
  ["relative" "bg-cover" "h-screen"])

(defmethod css :f/hero-overlay
  [_]
  ["absolute" "inset-0" "bg-black" "opacity-50"])

(defmethod css :f/hero-image
  [_]
  ["p-8" "mb-8" "bg-gray-200" "rounded-lg"])

(defmethod css :f/hero-text
  [_]
  ["text-lg" "md:text-xl" "text-gray-800" "max-w-xl"])

(defmethod css :comp/carousel
  [_]
  ["flex" "transition-transform" "duration-700" "ease-in-out"])

(defmethod css :comp/carousel-button
  [{:keys [direction bg fg] :or {fg default-fg bg default-bg}}]
  [(case direction
     :left "left-0"
     :right "right-0")
   bg fg
   "absolute" "top-1/2"
   "transform" "-translate-y-1/2" "p-2"
   "bg-opacity-50" "font-bold" "cursor-pointer"])

(defmethod css :f/carousel-wrapper
  [_]
  ["relative" "overflow-hidden" "w-fit"])

(defmethod css :comp/form
  [_]
  ["flex" "flex-col"])

(defmethod css :form/field
  [_]
  ["flex" "flex-col" "justify-between" "items-center" "md:flex-row"])

(defmethod css :form/label
  [_]
  ["font-semibold" "w-full" "md:w-1/4"])

(defmethod css :input/text
  [_]
  ["my-2" "p-3" "w-full" "border" "rounded-md" "outline-none"])

(defmethod css :input/email
  [_]
  ["my-2" "p-3" "w-full" "border" "rounded-md" "outline-none"])

(defmethod css :input/tel
  [_]
  ["my-2" "p-3" "w-full" "border" "rounded-md" "outline-none"])

(defmethod css :input/longtext
  [_]
  ["my-2" "p-3" "w-full" "h-24" "border" "rounded-md" "outline-none"])

(defmethod css :input/select
  [_]
  ["p-3" "w-full" "border" "cursor-pointer" "rounded-md"])

(defmethod css :input/submit
  [_]
  ["my-2" "px-4" "py-2" "border-none" "rounded-md" "outline-none"
   "bg-green-400" "text-white" "text-center" "font-semibold"
   "cursor-pointer"])

(defmethod css :input/hidden
  [_]
  [])
