(ns atombind.cljs-macros)

(defmacro deftest
  [testname desc & body]
  `(do
     (defonce ~'NS-TESTS (atom []))
     (defonce ~'run-all-tests (fn []
                                (doseq [t# @~'NS-TESTS]
                                  (t#))))
     (defn ~testname
       []
       (try
         ~@body
         (println (str ~desc ": PASS"))
         (catch js/Object e#
           (println (str ~desc ": FAIL - " e#)))))
     (swap! ~'NS-TESTS conj ~testname)))
