(ns prism.internal.classpath
  (:import
    (clojure.lang Compiler$CompilerException)
    (java.io FileNotFoundException)))

(defn missing-dep [& deps]
  (fn [& _]
    (throw (ex-info "Function does not exist due to missing dependencies"
                    {:deps deps}))))

(defmacro when-ns [ns & body]
  `(try
     (eval '(do (require ~ns) ~@body))
     (catch FileNotFoundException ~'_)
     (catch Compiler$CompilerException ~'_)))

(defmacro if-ns [ns then else]
  `(try
     (eval '(do (require ~ns)
                ~then))
     (catch FileNotFoundException ~'_ ~else)))

(defmacro when-class [cls & body]
  `(try
     (eval '(do (import ~cls) ~@body))
     (catch ClassNotFoundException ~'_)))

(comment
  (if-ns 'prism.core
    (throw (Exception. "Should not be caught"))
    (println "should not be reached"))
  (if-ns 'prism.corex
    (println "should not be reached")
    (throw (Exception. "Should not be caught")))
  (when-ns 'prism.core
    (throw (Exception. "Should not be caught")))
  (when-ns 'prism.corex
    (println "should not be reached"))
  (when-ns 'prism.redis
    (println "should only be reached when carmine dep is present")))
