(ns prism.http-server
  (:require
    [prism.core :as prism]
    [prism.internal.classpath :as cp]
    [ring.adapter.jetty9 :as jetty]
    [taoensso.trove :as trove])
  (:import
    (org.eclipse.jetty.server Server)))

(require 'ring.adapter.jetty9.http2) ;needs to be included at build time for graal, but is typically loaded lazily

(defn- configure-server [^Server server]
  (.addShutdownHook (Runtime/getRuntime)
                    (Thread. #(do
                                (trove/log! {:msg "Stopping server."})
                                (.stop server)
                                (cp/when-ns 'prism.postgres
                                  (trove/log! {:msg "Shutting down DB connection pool."})
                                  (.close (prism.postgres/data-src)))
                                (cp/when-ns 'prism.apache-http-client
                                  (trove/log! {:msg "Shutting down default HTTP client."})
                                  (.close (prism.apache-http-client/default-http-client)))))))

(defn start-server! ^Server [handler & {:as jetty-opts}]
  (let [http-port (-> (prism/config) :http-port)
        http-host (-> (prism/config) :http-host)]
    (trove/log! {:msg (format "Starting server on port %d"
                              (if (or (:http? jetty-opts true)
                                      (:h2c? jetty-opts true))
                                (:port jetty-opts http-port)
                                (:ssl-port jetty-opts)))})
    (->> (merge {:port                 http-port
                 :host                 http-host
                 :h2c?                 true
                 :join?                false
                 :virtual-threads?     true
                 :configurator         configure-server
                 :send-server-version? false} jetty-opts)
         (jetty/run-jetty handler))))
