package prism.internal;

import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.support.classic.AbstractClassicEntityProducer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.Executor;

public class InputStreamEntityProducer extends AbstractClassicEntityProducer {
    private final InputStream inputStream;
    private final int bufferSize;

    public InputStreamEntityProducer(InputStream inputStream, int initialBufferSize, ContentType contentType, Executor executor) {
        super(initialBufferSize, contentType, executor);
        this.bufferSize = initialBufferSize;
        this.inputStream = inputStream;
    }

    //taken from InputStream#transferTo(OutputStream), but with custom buffer size
    private void transferInputStream(InputStream inputStream, OutputStream out) throws IOException {
        Objects.requireNonNull(out, "out");
        int bufferSize = this.bufferSize; //avoid getfield opcode
        long transferred = 0;
        byte[] buffer = new byte[bufferSize];
        int read;
        while ((read = inputStream.read(buffer, 0, bufferSize)) >= 0) {
            out.write(buffer, 0, read);
            if (transferred < Long.MAX_VALUE) {
                try {
                    transferred = Math.addExact(transferred, read);
                } catch (ArithmeticException ignore) {
                    transferred = Long.MAX_VALUE;
                }
            }
        }
    }

    @Override
    protected void produceData(ContentType _contentType, OutputStream outputStream) throws IOException {
        try (InputStream is = this.inputStream;
             OutputStream os = outputStream) {
            transferInputStream(is, os);
        }
    }
}
