(ns prism.internal.classpath)

(defn missing-dep [& deps]
  (fn [& _]
    (throw (ex-info "Function does not exist due to missing dependencies"
                    {:deps deps}))))

(defmacro when-ns [ns & body]
  `(try
     (eval '(do (require ~ns) ~@body))
     (catch Exception ~'_)))

(defmacro if-ns [ns then else]
  `(try
     (eval '(do (require ~ns) ~then))
     (catch Exception ~'_ ~else)))
