(ns prism.internal.classpath
  (:require
    [clojure.reflect :refer [resolve-class]]))

(defn class-exists? [c]
  (-> (Thread/currentThread)
      .getContextClassLoader
      (resolve-class c)
      some?))

(defn checked-require [coll]
  (try
    (require coll)
    (find-ns (first coll))
    (catch Exception _
      false)))

(defn missing-dep [& deps]
  (fn [& _]
    (throw (ex-info "Function does not exist due to missing dependencies"
                    {:deps deps}))))

(defmacro eval-when [test & body]
  (when (eval test)
    (cons 'do body)))

(defmacro eval-if [test then else]
  (if (eval test)
    then
    else))
