/*
 * Decompiled with CFR 0.152.
 */
package io.clubhouse.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class Slf4jJsonReporter
extends ScheduledReporter {
    private final JsonNode requiredJsonNode;
    private final ObjectMapper mapper;
    private final LoggerProxy loggerProxy;
    private final Marker marker;
    private final String prefix;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private Slf4jJsonReporter(MetricRegistry registry, LoggerProxy loggerProxy, JsonNode requiredJsonNode, Marker marker, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, Set<MetricAttribute> disabledMetricAttributes) {
        super(registry, "logger-reporter", filter, rateUnit, durationUnit, executor, shutdownExecutorOnStop, disabledMetricAttributes);
        this.loggerProxy = loggerProxy;
        this.mapper = new ObjectMapper();
        this.requiredJsonNode = requiredJsonNode;
        this.marker = marker;
        this.prefix = prefix;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (this.loggerProxy.isEnabled(this.marker)) {
            StringBuilder b = new StringBuilder();
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.logGauge(b, entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.logCounter(b, entry.getKey(), (Counter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.logHistogram(b, entry.getKey(), (Histogram)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.logMeter(b, entry.getKey(), (Meter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.logTimer(b, entry.getKey(), (Timer)entry.getValue());
            }
        }
    }

    private void logTimer(StringBuilder b, String name, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        b.setLength(0);
        b.append("{\"tag\":\"metrics-timer\"");
        this.append(b, "metric_name", this.prefix(name));
        this.appendCountIfEnabled(b, (Counting)timer);
        this.appendLongDurationIfEnabled(b, MetricAttribute.MIN, () -> ((Snapshot)snapshot).getMin());
        this.appendLongDurationIfEnabled(b, MetricAttribute.MAX, () -> ((Snapshot)snapshot).getMax());
        this.appendDoubleDurationIfEnabled(b, MetricAttribute.MEAN, () -> ((Snapshot)snapshot).getMean());
        this.appendDoubleDurationIfEnabled(b, MetricAttribute.STDDEV, () -> ((Snapshot)snapshot).getStdDev());
        this.appendDoubleDurationIfEnabled(b, MetricAttribute.P50, () -> ((Snapshot)snapshot).getMedian());
        this.appendDoubleDurationIfEnabled(b, MetricAttribute.P75, () -> ((Snapshot)snapshot).get75thPercentile());
        this.appendDoubleDurationIfEnabled(b, MetricAttribute.P95, () -> ((Snapshot)snapshot).get95thPercentile());
        this.appendDoubleDurationIfEnabled(b, MetricAttribute.P98, () -> ((Snapshot)snapshot).get98thPercentile());
        this.appendDoubleDurationIfEnabled(b, MetricAttribute.P99, () -> ((Snapshot)snapshot).get99thPercentile());
        this.appendDoubleDurationIfEnabled(b, MetricAttribute.P999, () -> ((Snapshot)snapshot).get999thPercentile());
        this.appendMetered(b, (Metered)timer);
        this.append(b, "rate_unit", this.getRateUnit());
        this.append(b, "duration_unit", this.getDurationUnit());
        b.append('}');
        this.loggerProxy.log(this.marker, this.mergeJson(b.toString()));
    }

    private void logMeter(StringBuilder b, String name, Meter meter) {
        b.setLength(0);
        b.append("{\"tag\":\"metrics-meter\"");
        this.append(b, "metric_name", this.prefix(name));
        this.appendCountIfEnabled(b, (Counting)meter);
        this.appendMetered(b, (Metered)meter);
        this.append(b, "rate_unit", this.getRateUnit());
        b.append('}');
        this.loggerProxy.log(this.marker, this.mergeJson(b.toString()));
    }

    private void logHistogram(StringBuilder b, String name, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        b.setLength(0);
        b.append("{\"tag\":\"metrics-histogram\"");
        this.append(b, "metric_name", this.prefix(name));
        this.appendCountIfEnabled(b, (Counting)histogram);
        this.appendLongIfEnabled(b, MetricAttribute.MIN, () -> ((Snapshot)snapshot).getMin());
        this.appendLongIfEnabled(b, MetricAttribute.MAX, () -> ((Snapshot)snapshot).getMax());
        this.appendDoubleIfEnabled(b, MetricAttribute.MEAN, () -> ((Snapshot)snapshot).getMean());
        this.appendDoubleIfEnabled(b, MetricAttribute.STDDEV, () -> ((Snapshot)snapshot).getStdDev());
        this.appendDoubleIfEnabled(b, MetricAttribute.P50, () -> ((Snapshot)snapshot).getMedian());
        this.appendDoubleIfEnabled(b, MetricAttribute.P75, () -> ((Snapshot)snapshot).get75thPercentile());
        this.appendDoubleIfEnabled(b, MetricAttribute.P95, () -> ((Snapshot)snapshot).get95thPercentile());
        this.appendDoubleIfEnabled(b, MetricAttribute.P98, () -> ((Snapshot)snapshot).get98thPercentile());
        this.appendDoubleIfEnabled(b, MetricAttribute.P99, () -> ((Snapshot)snapshot).get99thPercentile());
        this.appendDoubleIfEnabled(b, MetricAttribute.P999, () -> ((Snapshot)snapshot).get999thPercentile());
        b.append('}');
        this.loggerProxy.log(this.marker, this.mergeJson(b.toString()));
    }

    private void logCounter(StringBuilder b, String name, Counter counter) {
        b.setLength(0);
        b.append("{\"tag\":\"metrics-counter\"");
        this.append(b, "metric_name", this.prefix(name));
        this.append(b, MetricAttribute.COUNT.getCode(), counter.getCount());
        b.append('}');
        this.loggerProxy.log(this.marker, this.mergeJson(b.toString()));
    }

    private void logGauge(StringBuilder b, String name, Gauge<?> gauge) {
        b.setLength(0);
        b.append("{\"tag\":\"metrics-gauge\"");
        this.append(b, "metric_name", this.prefix(name));
        this.append(b, "value", gauge.getValue());
        b.append('}');
        this.loggerProxy.log(this.marker, this.mergeJson(b.toString()));
    }

    private void appendLongDurationIfEnabled(StringBuilder b, MetricAttribute metricAttribute, Supplier<Long> durationSupplier) {
        if (!this.getDisabledMetricAttributes().contains(metricAttribute)) {
            this.append(b, metricAttribute.getCode(), this.convertDuration(durationSupplier.get().longValue()));
        }
    }

    private void appendDoubleDurationIfEnabled(StringBuilder b, MetricAttribute metricAttribute, Supplier<Double> durationSupplier) {
        if (!this.getDisabledMetricAttributes().contains(metricAttribute)) {
            this.append(b, metricAttribute.getCode(), this.convertDuration(durationSupplier.get()));
        }
    }

    private void appendLongIfEnabled(StringBuilder b, MetricAttribute metricAttribute, Supplier<Long> valueSupplier) {
        if (!this.getDisabledMetricAttributes().contains(metricAttribute)) {
            this.append(b, metricAttribute.getCode(), valueSupplier.get());
        }
    }

    private void appendDoubleIfEnabled(StringBuilder b, MetricAttribute metricAttribute, Supplier<Double> valueSupplier) {
        if (!this.getDisabledMetricAttributes().contains(metricAttribute)) {
            this.append(b, metricAttribute.getCode(), valueSupplier.get());
        }
    }

    private void appendCountIfEnabled(StringBuilder b, Counting counting) {
        if (!this.getDisabledMetricAttributes().contains(MetricAttribute.COUNT)) {
            this.append(b, MetricAttribute.COUNT.getCode(), counting.getCount());
        }
    }

    private void appendMetered(StringBuilder b, Metered meter) {
        this.appendRateIfEnabled(b, MetricAttribute.M1_RATE, () -> ((Metered)meter).getOneMinuteRate());
        this.appendRateIfEnabled(b, MetricAttribute.M5_RATE, () -> ((Metered)meter).getFiveMinuteRate());
        this.appendRateIfEnabled(b, MetricAttribute.M15_RATE, () -> ((Metered)meter).getFifteenMinuteRate());
        this.appendRateIfEnabled(b, MetricAttribute.MEAN_RATE, () -> ((Metered)meter).getMeanRate());
    }

    private void appendRateIfEnabled(StringBuilder b, MetricAttribute metricAttribute, Supplier<Double> rateSupplier) {
        if (!this.getDisabledMetricAttributes().contains(metricAttribute)) {
            this.append(b, metricAttribute.getCode(), this.convertRate(rateSupplier.get()));
        }
    }

    private void append(StringBuilder b, String key, long value) {
        this.appendLong(b, key, value);
    }

    private void append(StringBuilder b, String key, double value) {
        this.appendDouble(b, key, value);
    }

    private void append(StringBuilder b, String key, String value) {
        b.append(",\"").append(key).append("\":\"").append(value).append("\"");
    }

    private void append(StringBuilder b, String key, Object value) {
        if (value instanceof Double) {
            this.appendDouble(b, key, (Double)value);
        } else if (value instanceof Long) {
            this.appendLong(b, key, (Long)value);
        } else {
            b.append(",\"").append(key).append("\":\"").append(value).append("\"");
        }
    }

    private void appendLong(StringBuilder b, String key, long value) {
        b.append(",\"").append(key).append("\":").append(value);
    }

    private void appendDouble(StringBuilder b, String key, double value) {
        b.append(",\"").append(key).append("\":").append(value);
    }

    protected String getRateUnit() {
        return "events/" + super.getRateUnit();
    }

    private String prefix(String ... components) {
        return MetricRegistry.name((String)this.prefix, (String[])components);
    }

    public String mergeJson(String jsonSource) {
        try {
            JsonNode jsonNode = this.mapper.readTree(jsonSource);
            if (this.requiredJsonNode != null) {
                Iterator it = this.requiredJsonNode.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    ((ObjectNode)jsonNode).put((String)entry.getKey(), ((JsonNode)entry.getValue()).textValue());
                }
            }
            return this.mapper.writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            if (this.requiredJsonNode != null) {
                JsonNode returnJson = this.requiredJsonNode.deepCopy();
                ((ObjectNode)returnJson).put("metric_error", "JsonProcessingException: " + e.getMessage());
                try {
                    return this.mapper.writeValueAsString((Object)returnJson);
                }
                catch (JsonProcessingException ex) {
                    this.loggerProxy.logger.error("Failed to produce metrics JSON.", (Throwable)ex);
                }
            }
            return jsonSource;
        }
    }

    private static class ErrorLoggerProxy
    extends LoggerProxy {
        public ErrorLoggerProxy(Logger logger) {
            super(logger);
        }

        @Override
        public void log(Marker marker, String format) {
            this.logger.error(marker, format);
        }

        @Override
        public boolean isEnabled(Marker marker) {
            return this.logger.isErrorEnabled(marker);
        }
    }

    private static class WarnLoggerProxy
    extends LoggerProxy {
        public WarnLoggerProxy(Logger logger) {
            super(logger);
        }

        @Override
        public void log(Marker marker, String format) {
            this.logger.warn(marker, format);
        }

        @Override
        public boolean isEnabled(Marker marker) {
            return this.logger.isWarnEnabled(marker);
        }
    }

    private static class InfoLoggerProxy
    extends LoggerProxy {
        public InfoLoggerProxy(Logger logger) {
            super(logger);
        }

        @Override
        public void log(Marker marker, String format) {
            this.logger.info(marker, format);
        }

        @Override
        public boolean isEnabled(Marker marker) {
            return this.logger.isInfoEnabled(marker);
        }
    }

    private static class TraceLoggerProxy
    extends LoggerProxy {
        public TraceLoggerProxy(Logger logger) {
            super(logger);
        }

        @Override
        public void log(Marker marker, String format) {
            this.logger.trace(marker, format);
        }

        @Override
        public boolean isEnabled(Marker marker) {
            return this.logger.isTraceEnabled(marker);
        }
    }

    private static class DebugLoggerProxy
    extends LoggerProxy {
        public DebugLoggerProxy(Logger logger) {
            super(logger);
        }

        @Override
        public void log(Marker marker, String format) {
            this.logger.debug(marker, format);
        }

        @Override
        public boolean isEnabled(Marker marker) {
            return this.logger.isDebugEnabled(marker);
        }
    }

    static abstract class LoggerProxy {
        protected final Logger logger;

        public LoggerProxy(Logger logger) {
            this.logger = logger;
        }

        abstract void log(Marker var1, String var2);

        abstract boolean isEnabled(Marker var1);
    }

    public static class Builder {
        private final ObjectMapper mapper = new ObjectMapper();
        private final MetricRegistry registry;
        private JsonNode requiredJsonNode = null;
        private Logger logger;
        private LoggingLevel loggingLevel;
        private Marker marker;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private ScheduledExecutorService executor;
        private boolean shutdownExecutorOnStop;
        private Set<MetricAttribute> disabledMetricAttributes;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.logger = LoggerFactory.getLogger((String)"metrics");
            this.marker = null;
            this.prefix = "";
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.loggingLevel = LoggingLevel.INFO;
            this.executor = null;
            this.shutdownExecutorOnStop = true;
            this.disabledMetricAttributes = Collections.emptySet();
        }

        public Builder setRequiredJsonObject(String jsonSource) throws JsonProcessingException {
            this.requiredJsonNode = this.mapper.readTree(jsonSource);
            return this;
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder scheduleOn(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder outputTo(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder markWith(Marker marker) {
            this.marker = marker;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withLoggingLevel(LoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public Builder disabledMetricAttributes(Set<MetricAttribute> disabledMetricAttributes) {
            this.disabledMetricAttributes = disabledMetricAttributes;
            return this;
        }

        public Slf4jJsonReporter build() {
            LoggerProxy loggerProxy;
            switch (this.loggingLevel) {
                case TRACE: {
                    loggerProxy = new TraceLoggerProxy(this.logger);
                    break;
                }
                case INFO: {
                    loggerProxy = new InfoLoggerProxy(this.logger);
                    break;
                }
                case WARN: {
                    loggerProxy = new WarnLoggerProxy(this.logger);
                    break;
                }
                case ERROR: {
                    loggerProxy = new ErrorLoggerProxy(this.logger);
                    break;
                }
                default: {
                    loggerProxy = new DebugLoggerProxy(this.logger);
                }
            }
            return new Slf4jJsonReporter(this.registry, loggerProxy, this.requiredJsonNode, this.marker, this.prefix, this.rateUnit, this.durationUnit, this.filter, this.executor, this.shutdownExecutorOnStop, this.disabledMetricAttributes);
        }
    }

    public static enum LoggingLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

