(ns bloom.decant.ring
  (:require
    [bloom.decant.core :as decant]))

(defn route [tx-id]
  (fn [request]
    (try
      (decant/do! tx-id (request :params))
      {:status 200}
      (catch clojure.lang.ExceptionInfo e
        {:body (.getMessage e)
         :status (case (:anomaly (ex-data e))
                   :incorrect 400
                   :unsupported 500)}))))
