(ns bloom.commons.tada.rpc.client
  (:require
    [bloom.commons.ajax :as ajax]))

(defn make-dispatch
  [{:keys [base-path] :as opts}]
  (fn
    [[event-id event-params {:keys [on-success on-error]}]]
    (ajax/request
      {:uri (str base-path "/" (namespace event-id) "." (name event-id))
       :method :POST
       :params {:event-id event-id
                :event-params event-params}
       :on-success on-success
       :on-error on-error})))
