(ns bloom.commons.config
  (:refer-clojure :exclude [read])
  (:require
   [clojure.java.io :as io]
   [clojure.pprint :as pprint]
   [clojure.string :as string]
   [clojure.tools.reader.edn :as edn]
   [malli.core :as malli]
   [malli.error :as malli.error]
   [malli.transform :as malli.transform]))

(defn ^:private parse-file
  [path]
  (when (.exists (io/file path))
    (->> path
         slurp
         edn/read-string)))

(defn parse [config schema]
  (if (malli/validate schema config)
    (malli/decode schema config malli.transform/strip-extra-keys-transformer)
    (let [cause (malli/explain schema config)]
      (throw
       (ex-info (str "Config invalid\n"
                     (with-out-str
                       (pprint/pprint (malli.error/humanize cause)))) cause)))))

(defn read [source-path schema]
  (if-let [config (parse-file source-path)]
    (parse config schema)
    (throw
     (ex-info (str "Config file missing (" source-path ")") {}))))
