(ns bloom.commons.ui.textarea)

(defn- resize-textbox! [el]
  (set! (.. el -style -height) "auto")
  (let [new-height (str (+ 1 (.-scrollHeight el)) "px")]
    (set! (.. el -style -height) new-height)
    ;; also change the height of the parent node
    ;; which has a fixed height and overflow: hidden
    ;; to prevent browser from firing an extra scroll event
    ;; because of the 2 resizes that occur in the above
    (set! (.. el -parentNode -style -height) new-height)))

(defn textarea
  "An auto-resizing textarea. Accepts opts that are passed on to the textarea element."
  [opts]
  ;; wrap with a div that has a fixed height and overflow: hidden
  ;; so that the auto-resize behaviour of the underlying textarea
  ;; (which involves shrinking it and re-growing it)
  ;; does not cause two scroll/resize events
  [:div.textarea {:style {:overflow "hidden"
                          ;; height gets overriden by JS
                          :height "0px"}}
   [:textarea (merge
                opts
                {:ref (fn [x]
                        (when x
                          (when (opts :ref)
                            ((opts :ref) x))
                          (resize-textbox! x)))
                 :style (merge {:resize "none"}
                               (opts :style))
                 :on-change (fn [e]
                              (when (opts :on-change)
                                ((opts :on-change) e))
                              (resize-textbox! (.. e -target)))})]])
