(ns bloom.commons.thread-safe-io
  (:refer-clojure :exclude [spit slurp])
  (:require
    [clojure.java.io :as io]))

(defn -file-agent
  [file-name]
  (add-watch
    (agent nil) :file-writer
    (fn [_ _ _ [op cb ?arg]]
      (cb
        (try
          (case op
            :write (with-open [w (io/writer file-name)]
                     (.write w ?arg)
                     (.flush w))
            :read (clojure.core/slurp file-name))
          (catch java.io.FileNotFoundException e
            e))))))

(def file-agent (memoize -file-agent))

(defn spit
  [file-name content]
  (let [p (promise)]
    (send (file-agent file-name)
          (constantly [:write (fn [result]
                                (deliver p result))
                       content
                       ]))
    (let [result @p]
      (if (instance? Throwable result)
        (throw result)
        result))))

(defn slurp
  [file-name]
  (let [p (promise)]
    (send (file-agent file-name)
          (constantly [:read (fn [content]
                               (deliver p content))]))
    (let [result @p]
      (if (instance? Throwable result)
        (throw result)
        result))))


#_(dotimes [n 100]
    (future (spit "fstest/test.edn" (repeat 100000 n)))
    (future (clojure.core/spit (str "fstest/out" n)
                               (try
                                 ((juxt (partial apply =)
                                        first)
                                  (read-string (slurp "fstest/test.edn")))
                                 (catch Throwable e
                                   e)))))
