(ns bloom.commons.ui.emoji-favicon)

(defn svg [emoji]
  (str "data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 100 100%22><text y=%22.9em%22 font-size=%2290%22>" emoji "</text></svg>"))

(defn emoji-favicon
  [emoji]
  (if-let [element (.querySelector js/document "link[data-emoji-favicon]")]
    (when (not= emoji (.getAttribute element "data-emoji-favicon"))
      (.setAttribute element "href" (svg emoji)))
    (let [element (.createElement js/document "link")]
      (.setAttribute element "data-emoji-favicon" "emoji-favicon")
      (.setAttribute element "rel"  "icon")
      (.setAttribute element "href" (svg emoji))
      (.appendChild (.querySelector js/document "head") element)))
  nil)
