(ns bloom.commons.query-params
  (:require
   [clojure.string :as string]
   #?(:clj
      [ring.util.codec :as ring.codec])))

(defn coerce-to-string [o]
  (cond
    (keyword? o)
    (name o)

    :else
    (str o)))

(defn url-encode [value]
  #?(:cljs
     (js/encodeURIComponent (string/replace (coerce-to-string value) "%20" "+"))
     :clj
     (ring.codec/url-encode (coerce-to-string value))))

(defn params->string
  "Given map of params (allowing array values), returns a query string;
   Keys are sorted, and values within a key are sorted.
   (sorting is done to improve cacheability)"
  [params]
  (->> params
       sort
       (mapcat (fn [[k v]]
                 (cond
                   (coll? v)
                   (for [v' (sort v)]
                     (str (name k) "[]" "=" (url-encode v')))
                   :else
                   [(str (name k) "=" (url-encode v))])))
       (string/join "&")))

#?(:cljs
   (defn url->params
     "Given goog.Uri, read query parameters into Clojure map."
     [^Uri uri]
     (let [q (.getQueryData uri)]
       (->> q
            (.getKeys)
            distinct
            (map (fn [k]
                   ;; TODO this is fragile, can do better
                   (if (string/ends-with? k "[]")
                     [(-> k
                          (string/replace "[]" "")
                          keyword)
                      (vec (.getValues q k))]
                     [(keyword k) (aget (.getValues q k) 0)])))
            (into {})))))
