(ns bloom.commons.tada.rpc.server
  (:require
    [muuntaja.core :as muuntaja]
    [muuntaja.middleware :as muuntaja.middleware]
    [tada.events.ring]))

(defn make-handler
  [{:keys [extra-params] :as opts}]
  (-> (fn [request]
        (let [{:keys [event-id event-params]} (request :body-params)]
          (tada.events.ring/ring-dispatch-event!
            event-id
            (merge event-params
                   (extra-params request)))))
      (muuntaja.middleware/wrap-format
        (-> muuntaja/default-options
            (update :formats select-keys ["application/transit+json"])
            (assoc :default-format "application/transit+json")))))
