(ns bloom.commons.geo)

(defn- to-radians
  [angle]
  (* angle (/ Math/PI 180)))

(defn distance
  [[lon1 lat1] [lon2 lat2]]
  (let [R 6378.137 ; Radius of Earth in km
        dlat (to-radians (- lat2 lat1))
        dlon (to-radians (- lon2 lon1))
        lat-in-radians-1 (to-radians lat1)
        lat-in-radians-2 (to-radians lat2)
        a (+ (* (Math/sin (/ dlat 2))
                (Math/sin (/ dlat 2)))
             (* (Math/sin (/ dlon 2))
                (Math/sin (/ dlon 2))
                (Math/cos lat-in-radians-1)
                (Math/cos lat-in-radians-2)))]
    (* R 2 (Math/asin (Math/sqrt a)))))
