(ns bloom.commons.tada.rpc.client
  (:require
    [bloom.commons.ajax :as ajax]))

(defn make-dispatch
  [{:keys [base-path] :as opts}]
  (fn
    [[event-id event-params
      {:keys [on-success on-error]
       :or {on-success (constantly nil)
            on-error (fn [err]
                       (.error js/console "tada.rpc request error: " (pr-str err)))}}]]
    (ajax/request
      {:uri (str base-path "/" (namespace event-id) "." (name event-id))
       :method :POST
       :params {:event-id event-id
                :event-params event-params}
       :on-success on-success
       :on-error on-error})))
