/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.messaging.artemis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.embedded.EmbeddedJMS;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.projectodd.wunderboss.Options;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.messaging.Messaging;
import org.projectodd.wunderboss.messaging.jms.DestinationUtil;
import org.projectodd.wunderboss.messaging.jms.JMSDestination;
import org.projectodd.wunderboss.messaging.jms.JMSMessagingSkeleton;
import org.slf4j.Logger;

public class ArtemisMessaging
extends JMSMessagingSkeleton {
    private final String name;
    private final Options<Messaging.CreateOption> options;
    private boolean started = false;
    private EmbeddedJMS server;
    private static final Logger log = WunderBoss.logger((String)"org.projectodd.wunderboss.messaging.artemis");

    public ArtemisMessaging(String name, Options<Messaging.CreateOption> options) {
        this.name = name;
        this.options = options;
    }

    public synchronized void start() throws Exception {
        if (!this.started) {
            this.server = new EmbeddedJMS();
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            if (cl.getResource("broker.xml") == null) {
                this.server.setConfigResourcePath("default-broker.xml");
            }
            this.server.start();
            this.started = true;
            TransportConfiguration config = new TransportConfiguration(InVMConnectorFactory.class.getName());
            BindingRegistry registry = this.jmsServerManager().getRegistry();
            registry.bind("java:/ConnectionFactory", (Object)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{config}));
            registry.bind("java:/JmsXA", (Object)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])new TransportConfiguration[]{config}));
        }
    }

    public synchronized void stop() throws Exception {
        if (this.started) {
            this.closeCloseables();
            this.server.stop();
            this.server = null;
            this.started = false;
        }
    }

    public synchronized boolean isRunning() {
        return this.started;
    }

    public JMSServerManager jmsServerManager() {
        if (this.started) {
            return this.server.getJMSServerManager();
        }
        return null;
    }

    public String name() {
        return this.name;
    }

    protected ConnectionFactory createRemoteConnectionFactory(final Options<Messaging.CreateContextOption> options) {
        TransportConfiguration config = new TransportConfiguration(NettyConnectorFactory.class.getName(), (Map)new HashMap(){
            {
                this.put("host", options.getString((Object)Messaging.CreateContextOption.HOST));
                this.put("port", options.getInt((Object)Messaging.CreateContextOption.PORT));
            }
        });
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)(options.has((Object)Messaging.CreateContextOption.XA) ? JMSFactoryType.XA_CF : JMSFactoryType.CF), (TransportConfiguration[])new TransportConfiguration[]{config});
        cf.setReconnectAttempts(options.getInt((Object)Messaging.CreateContextOption.RECONNECT_ATTEMPTS).intValue());
        cf.setRetryInterval(options.getLong((Object)Messaging.CreateContextOption.RECONNECT_RETRY_INTERVAL).longValue());
        cf.setRetryIntervalMultiplier(options.getDouble((Object)Messaging.CreateContextOption.RECONNECT_RETRY_INTERVAL_MULTIPLIER).doubleValue());
        cf.setMaxRetryInterval(options.getLong((Object)Messaging.CreateContextOption.RECONNECT_MAX_RETRY_INTERVAL).longValue());
        return cf;
    }

    protected Topic createTopic(String name) throws Exception {
        this.server.getJMSServerManager().createTopic(false, name, new String[]{DestinationUtil.jndiName((String)name, (JMSDestination.Type)JMSDestination.Type.TOPIC)});
        return this.lookupTopic(name);
    }

    protected Queue createQueue(String name, String selector, boolean durable) throws Exception {
        this.server.getJMSServerManager().createQueue(false, name, selector, durable, new String[]{DestinationUtil.jndiName((String)name, (JMSDestination.Type)JMSDestination.Type.QUEUE)});
        return this.lookupQueue(name);
    }

    protected Topic lookupTopic(String name) {
        ArrayList<String> jndiNames = new ArrayList<String>();
        if (this.server != null) {
            jndiNames.addAll(Arrays.asList(this.server.getJMSServerManager().getBindingsOnTopic(name)));
        }
        jndiNames.add(name);
        jndiNames.add(DestinationUtil.jmsName((String)name, (JMSDestination.Type)JMSDestination.Type.TOPIC));
        jndiNames.add(DestinationUtil.jndiName((String)name, (JMSDestination.Type)JMSDestination.Type.TOPIC));
        return (Topic)this.lookupJNDI(jndiNames);
    }

    protected Queue lookupQueue(String name) {
        ArrayList<String> jndiNames = new ArrayList<String>();
        if (this.server != null) {
            jndiNames.addAll(Arrays.asList(this.server.getJMSServerManager().getBindingsOnQueue(name)));
        }
        jndiNames.add(name);
        jndiNames.add(DestinationUtil.jmsName((String)name, (JMSDestination.Type)JMSDestination.Type.QUEUE));
        jndiNames.add(DestinationUtil.jndiName((String)name, (JMSDestination.Type)JMSDestination.Type.QUEUE));
        return (Queue)this.lookupJNDI(jndiNames);
    }

    protected void destroyQueue(String name) throws Exception {
        this.jmsServerManager().destroyQueue(name, true);
    }

    protected void destroyTopic(String name) throws Exception {
        this.jmsServerManager().destroyTopic(name, true);
    }

    protected Object lookupJNDI(String jndiName) {
        return this.server.getRegistry().lookup(jndiName);
    }
}

