/*
 * Decompiled with CFR 0.152.
 */
package io.async.core;

import io.async.core.AsyncIOException;
import io.async.core.Channel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.javatuples.Pair;

public class SocketConnectionManager {
    private static final Properties defaultConfig = new Properties(){
        {
            this.put("CONNECTION_TIMEOUT", Long.toString(1000L));
            this.put("READ_TIMEOUT", Long.toString(1000L));
            this.put("READ_BUFFER_CAPACITY", Integer.toString(1024));
            this.put("READ_QUEUE_SIZE", Integer.toString(100));
            this.put("READ_TASK_QUEUE_SIZE", Integer.toString(1024));
            this.put("CONCURRENT_CONNECTION_COUNT", Integer.toString(100));
            this.put("CONNECTION_QUEUE_SIZE", Integer.toString(1000000));
            this.put("WRITE_TIMEOUT", Long.toString(1000L));
        }
    };
    private final AsynchronousChannelGroup channelGroup;
    private final ExecutorService callBackThreadPool;
    private int connectionQueueSize;
    private Map<Channel, AsynchronousSocketChannelWrapper> channelWrapperMapping = new ConcurrentHashMap<Channel, AsynchronousSocketChannelWrapper>();
    private LinkedBlockingDeque<Pair<BiConsumer<Channel, AsynchronousSocketChannelWrapper>, Consumer<Throwable>>> connectionQueue;
    private long connectTimeout;
    private long readTimeOut;
    private int readBufferCapacity;
    private int readQueueSize;
    private int readTaskQueueSize;
    private int concurrentConnectionCount;
    private int writeTimeOut;
    private int connectionCount = 0;

    public SocketConnectionManager(ExecutorService ioThreadPool, ExecutorService callBackThreadPool) throws IOException {
        this(ioThreadPool, callBackThreadPool, new Properties());
    }

    public SocketConnectionManager(ExecutorService ioThreadPool, ExecutorService callBackThreadPool, Properties config) throws IOException {
        this.channelGroup = AsynchronousChannelGroup.withThreadPool(ioThreadPool);
        this.callBackThreadPool = callBackThreadPool;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)defaultConfig);
        props.putAll((Map<?, ?>)config);
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            switch (key) {
                case "CONNECTION_TIMEOUT": {
                    this.connectTimeout = Long.parseLong(value);
                    break;
                }
                case "READ_TIMEOUT": {
                    this.readTimeOut = Long.parseLong(value);
                    break;
                }
                case "READ_BUFFER_CAPACITY": {
                    this.readBufferCapacity = Integer.parseInt(value);
                    break;
                }
                case "READ_QUEUE_SIZE": {
                    this.readQueueSize = Integer.parseInt(value);
                    break;
                }
                case "READ_TASK_QUEUE_SIZE": {
                    this.readTaskQueueSize = Integer.parseInt(value);
                    break;
                }
                case "CONCURRENT_CONNECTION_COUNT": {
                    this.concurrentConnectionCount = Integer.parseInt(value);
                    break;
                }
                case "CONNECTION_QUEUE_SIZE": {
                    this.connectionQueueSize = Integer.parseInt(value);
                    break;
                }
                case "WRITE_TIMEOUT": {
                    this.writeTimeOut = Integer.parseInt(value);
                }
            }
        }
        this.connectionQueue = new LinkedBlockingDeque(this.connectionQueueSize);
    }

    public long getReadTimeOut() {
        return this.readTimeOut;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadBufferCapacity() {
        return this.readBufferCapacity;
    }

    public int getReadQueueSize() {
        return this.readQueueSize;
    }

    public int getReadTaskQueueSize() {
        return this.readTaskQueueSize;
    }

    public int getOpenChannelCount() {
        return this.channelWrapperMapping.size();
    }

    public Channel connect(String host, int port) {
        try {
            Channel channel = new Channel(this);
            AsynchronousSocketChannel ch = AsynchronousSocketChannel.open(this.channelGroup);
            AsynchronousSocketChannelWrapper wrapper = new AsynchronousSocketChannelWrapper(ch);
            this.putWrapper(channel, wrapper);
            this.doConnect(host, port, channel, ch);
            if (wrapper.isConnectComplete()) {
                if (!wrapper.isConnectSuccess()) {
                    if (wrapper.getConnectException() != null) {
                        throw new AsyncIOException("Connection Failed", wrapper.getConnectException());
                    }
                    throw new AsyncIOException("Connection Failed");
                }
            } else {
                throw new AsyncIOException("Connection Timeout");
            }
            return channel;
        }
        catch (IOException e) {
            throw new AsyncIOException("Failed open channel", e);
        }
    }

    private void putWrapper(Channel channel, AsynchronousSocketChannelWrapper wrapper) {
        this.channelWrapperMapping.put(channel, wrapper);
    }

    public void connect(String host, int port, Consumer<Channel> onSuccess, Consumer<Throwable> onFail) {
        boolean couldConnect = this.requestConnection();
        try {
            if (!couldConnect) {
                BiConsumer<Channel, AsynchronousSocketChannelWrapper> s = (ch, wrapper) -> {
                    wrapper.setOnConnectFailConsumer(onFail);
                    wrapper.setOnConnectSuccessConsumer(onSuccess);
                    this.putWrapper((Channel)ch, (AsynchronousSocketChannelWrapper)wrapper);
                    this.doConnect(host, port, (Channel)ch, wrapper.getChannel());
                };
                Consumer<Throwable> f = e -> onFail.accept((Throwable)e);
                if (!this.connectionQueue.offer((Pair<BiConsumer<Channel, AsynchronousSocketChannelWrapper>, Consumer<Throwable>>)new Pair(s, f))) {
                    throw new AsyncIOException("connection queue is full");
                }
            } else {
                Channel channel = new Channel(this);
                AsynchronousSocketChannel ch2 = AsynchronousSocketChannel.open(this.channelGroup);
                AsynchronousSocketChannelWrapper wrapper2 = new AsynchronousSocketChannelWrapper(ch2);
                wrapper2.setOnConnectFailConsumer(onFail);
                wrapper2.setOnConnectSuccessConsumer(onSuccess);
                this.putWrapper(channel, wrapper2);
                this.doConnect(host, port, channel, ch2);
            }
        }
        catch (IOException e2) {
            throw new AsyncIOException("Failed open channel", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestConnection() {
        boolean couldConnect = false;
        SocketConnectionManager socketConnectionManager = this;
        synchronized (socketConnectionManager) {
            if (this.connectionCount < this.concurrentConnectionCount) {
                ++this.connectionCount;
                couldConnect = true;
            }
        }
        return couldConnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection() {
        SocketConnectionManager socketConnectionManager = this;
        synchronized (socketConnectionManager) {
            --this.connectionCount;
        }
    }

    private void doConnect(String host, int port, Channel channel, AsynchronousSocketChannel ch) {
        try {
            AsynchronousSocketChannelWrapper wrapper = this.getWrapper(channel);
            if (wrapper != null) {
                wrapper.setConnectStartTime(System.currentTimeMillis());
            }
            ch.connect(new InetSocketAddress(host, port), channel, new CompletionHandler<Void, Channel>(){

                @Override
                public void completed(Void result, Channel attachment) {
                    AsynchronousSocketChannelWrapper wrapper = SocketConnectionManager.this.getWrapper(attachment);
                    if (wrapper != null) {
                        wrapper.connectSuccess();
                        if (wrapper.getOnConnectSuccessConsumer() != null) {
                            wrapper.getOnConnectSuccessConsumer().accept(attachment);
                        }
                    }
                }

                @Override
                public void failed(Throwable exc, Channel attachment) {
                    AsynchronousSocketChannelWrapper wrapper = SocketConnectionManager.this.getWrapper(attachment);
                    SocketConnectionManager.this.disconnect(attachment);
                    if (wrapper != null) {
                        wrapper.connectFailed(exc);
                        if (wrapper.getOnConnectFailConsumer() != null) {
                            wrapper.getOnConnectFailConsumer().accept(exc);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            throw new AsyncIOException("Connect Failed", e);
        }
    }

    private void runQueuedConnectionTask() {
        Pair<BiConsumer<Channel, AsynchronousSocketChannelWrapper>, Consumer<Throwable>> task;
        if (this.requestConnection() && (task = this.connectionQueue.poll()) != null) {
            Channel channel = this.createChannel();
            try {
                AsynchronousSocketChannel ch = AsynchronousSocketChannel.open(this.channelGroup);
                AsynchronousSocketChannelWrapper wr = new AsynchronousSocketChannelWrapper(ch);
                ((BiConsumer)task.getValue0()).accept(channel, wr);
            }
            catch (IOException e) {
                ((Consumer)task.getValue1()).accept(e);
            }
        }
    }

    private Channel createChannel() {
        return new Channel(this);
    }

    void disconnect(Channel channel) {
        AsynchronousSocketChannelWrapper wrapper = this.getWrapper(channel);
        if (wrapper != null) {
            try {
                wrapper.getChannel().close();
            }
            catch (Exception e) {
                throw new AsyncIOException("Channel close failed", e);
            }
            finally {
                this.channelWrapperMapping.remove(channel);
                this.releaseConnection();
                this.runQueuedConnectionTask();
            }
        }
    }

    private AsynchronousSocketChannelWrapper getWrapper(Channel channel) {
        return this.channelWrapperMapping.get(channel);
    }

    public ReadGuarder read(Channel channel, byte[] result, int off, int length) {
        AsynchronousSocketChannelWrapper wrapper = this.getWrapper(channel);
        ReadGuarder guarder = wrapper.commitRead(result, off, length);
        this.commitReadTask(channel);
        return guarder;
    }

    private void commitReadTask(Channel channel) {
        ReadTask task = new ReadTask();
        task.setChannel(channel);
        this.callBackThreadPool.submit(task);
    }

    public ReadGuarder read(Channel channel, byte[] result, int off, int length, IntConsumer onSuccess, Consumer<Throwable> onFail) {
        AsynchronousSocketChannelWrapper wrapper = this.getWrapper(channel);
        ReadGuarder guarder = wrapper.commitRead(result, off, length, onSuccess, onFail);
        this.commitReadTask(channel);
        return guarder;
    }

    public WriteGuarder write(Channel channel, byte[] buffer, int off, int length) {
        AsynchronousSocketChannelWrapper wrapper = this.getWrapper(channel);
        WriteGuarder guarder = new WriteGuarder();
        wrapper.getChannel().write(ByteBuffer.wrap(buffer, off, length), this.getWriteTimeOut(), TimeUnit.MILLISECONDS, channel, guarder);
        return guarder;
    }

    public int getWriteTimeOut() {
        return this.writeTimeOut;
    }

    public void write(Channel channel, byte[] buffer, int off, int length, Consumer<Integer> onComplete, Consumer<Throwable> onFailure) {
        AsynchronousSocketChannelWrapper wrapper = this.getWrapper(channel);
        WriteGuarder guarder = new WriteGuarder();
        guarder.setOnSuccess(onComplete);
        guarder.setOnFailed(onFailure);
        wrapper.getChannel().write(ByteBuffer.wrap(buffer, off, length), this.getWriteTimeOut(), TimeUnit.MILLISECONDS, channel, guarder);
    }

    public void printConnectionQueue() {
        System.out.println(this.connectionQueue);
    }

    static /* synthetic */ int access$300(SocketConnectionManager x0) {
        return x0.readBufferCapacity;
    }

    static /* synthetic */ int access$500(SocketConnectionManager x0) {
        return x0.readQueueSize;
    }

    static /* synthetic */ int access$600(SocketConnectionManager x0) {
        return x0.readTaskQueueSize;
    }

    public class WriteGuarder
    implements CompletionHandler<Integer, Channel> {
        private volatile boolean writeFailed = false;
        private volatile Throwable writeException;
        private volatile boolean finished = false;
        private Consumer<Integer> onSuccess;
        private Consumer<Throwable> onFailed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFinished(int timeout) {
            if (!this.finished) {
                try {
                    WriteGuarder writeGuarder = this;
                    synchronized (writeGuarder) {
                        this.wait(timeout);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 8] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    return this.finished;
                }
            }
            return this.finished;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isWriteFailed() {
            return this.writeFailed;
        }

        public Throwable getWriteException() {
            return this.writeException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, Channel attachment) {
            AsynchronousSocketChannelWrapper wrapper = (AsynchronousSocketChannelWrapper)SocketConnectionManager.this.channelWrapperMapping.get(attachment);
            wrapper.updateWriteCount(result);
            this.writeFailed = false;
            this.finished = true;
            WriteGuarder writeGuarder = this;
            synchronized (writeGuarder) {
                this.notifyAll();
            }
            if (this.onSuccess != null) {
                this.onSuccess.accept(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable exc, Channel attachment) {
            this.writeFailed = true;
            this.finished = true;
            this.writeException = exc;
            WriteGuarder writeGuarder = this;
            synchronized (writeGuarder) {
                this.notifyAll();
            }
            if (this.onFailed != null) {
                this.onFailed.accept(exc);
            }
        }

        public void setOnSuccess(Consumer<Integer> onSuccess) {
            this.onSuccess = onSuccess;
        }

        public void setOnFailed(Consumer<Throwable> onFailed) {
            this.onFailed = onFailed;
        }
    }

    private static enum TaskType {
        success(0),
        fail(1);

        private int value;

        private TaskType(int value) {
            this.value = value;
        }
    }

    private class CallBackTask
    implements Runnable {
        private TaskType taskType;
        private ReadGuarder guarder;
        private int readCount;

        private CallBackTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            switch (this.taskType) {
                case success: {
                    this.guarder.onSuccess.accept(this.readCount);
                    ReadGuarder readGuarder = this.guarder;
                    synchronized (readGuarder) {
                        this.guarder.notifyAll();
                        break;
                    }
                }
            }
        }

        public void setTaskType(TaskType taskType) {
            this.taskType = taskType;
        }

        public void setGuarder(ReadGuarder guarder) {
            this.guarder = guarder;
        }

        public void setReadCount(int readCount) {
            this.readCount = readCount;
        }
    }

    private class ReadTask
    implements Runnable {
        private Channel channel;

        private ReadTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AsynchronousSocketChannelWrapper wrapper = SocketConnectionManager.this.getWrapper(this.channel);
            Channel channel = this.channel;
            synchronized (channel) {
                wrapper.runReadTask(this.channel);
            }
        }

        public void setChannel(Channel channel) {
            this.channel = channel;
        }
    }

    class ReadGuarder {
        private final byte[] dest;
        private final int off;
        private final int length;
        private boolean finished = false;
        private volatile int position;
        private volatile int readCount = 0;
        private volatile boolean readFailed;
        private volatile Throwable readException;
        private IntConsumer onSuccess;
        private Consumer<Throwable> onFail;

        ReadGuarder(byte[] dest, int off, int length) {
            this.dest = dest;
            this.off = off;
            this.length = length;
            this.position = off;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void offer(byte[] src, int off, int len) {
            ReadGuarder readGuarder = this;
            synchronized (readGuarder) {
                System.arraycopy(src, off, this.dest, this.position, len);
                this.position += len;
                if (this.position >= this.length + this.off) {
                    this.finished = true;
                }
                this.readCount += len;
            }
            this.onFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onFinished() {
            if (this.finished) {
                if (this.readFailed) {
                    if (this.onFail != null) {
                        SocketConnectionManager.this.callBackThreadPool.submit(() -> {
                            this.onFail.accept(this.readException);
                            ReadGuarder readGuarder = this;
                            synchronized (readGuarder) {
                                this.notifyAll();
                            }
                        });
                    } else {
                        ReadGuarder readGuarder = this;
                        synchronized (readGuarder) {
                            this.notifyAll();
                        }
                    }
                } else if (this.onSuccess != null) {
                    CallBackTask task = new CallBackTask();
                    task.setTaskType(TaskType.success);
                    task.setGuarder(this);
                    task.setReadCount(this.readCount);
                    SocketConnectionManager.this.callBackThreadPool.submit(task);
                } else {
                    ReadGuarder readGuarder = this;
                    synchronized (readGuarder) {
                        this.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFinished(long timeout) {
            if (!this.finished) {
                try {
                    ReadGuarder readGuarder = this;
                    synchronized (readGuarder) {
                        this.wait(timeout);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 8] lbl7 : MonitorExitStatement: MONITOREXIT : var3_2
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    return this.finished;
                }
            }
            return this.finished;
        }

        public int remaining() {
            return this.length + this.off - this.position;
        }

        boolean isFinished() {
            return this.finished;
        }

        public int getReadCount() {
            return this.readCount;
        }

        void setReadCount(int readCount) {
            this.readCount = readCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finish() {
            ReadGuarder readGuarder = this;
            synchronized (readGuarder) {
                this.finished = true;
            }
            this.onFinished();
        }

        public void finish(Throwable readException) {
            this.readFailed = true;
            this.readException = readException;
            this.finish();
        }

        public boolean isReadFailed() {
            return this.readFailed;
        }

        public Throwable getReadException() {
            return this.readException;
        }

        void setOnSuccess(IntConsumer onSuccess) {
            this.onSuccess = onSuccess;
        }

        void setOnFail(Consumer<Throwable> onFail) {
            this.onFail = onFail;
        }
    }

    private class AsynchronousSocketChannelWrapper {
        AsynchronousSocketChannel channel;
        final Byte connectLock = 0;
        private volatile boolean connectComplete;
        private volatile boolean connectSuccess;
        private volatile Throwable connectException;
        private Consumer<Channel> onConnectSuccessConsumer;
        private Consumer<Throwable> onConnectFailConsumer;
        private volatile boolean readEOF = false;
        private ByteBuffer buffer = ByteBuffer.allocate(SocketConnectionManager.access$300(SocketConnectionManager.this));
        private ReadCompletionHandler readCompletionHandler = new ReadCompletionHandler();
        private volatile boolean readFailed = false;
        private volatile Throwable readException;
        private LinkedBlockingDeque<ByteBuffer> readQueue = new LinkedBlockingDeque(SocketConnectionManager.access$500(SocketConnectionManager.this));
        private volatile ByteBuffer tmpBuff;
        private volatile long readCount = 0L;
        private LinkedBlockingDeque<ReadGuarder> readTaskQueue = new LinkedBlockingDeque(SocketConnectionManager.access$600(SocketConnectionManager.this));
        private volatile ByteBuffer currentReadBuffer;
        private volatile ReadGuarder currentReadTask;
        private volatile long connectStartTime;
        private volatile long writeCount = 0L;
        private boolean readTaskRunning = false;

        AsynchronousSocketChannelWrapper(AsynchronousSocketChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connectFailed(Throwable ex) {
            this.connectComplete = true;
            this.connectSuccess = false;
            this.connectException = ex;
            Byte by = this.connectLock;
            synchronized (by) {
                this.connectLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connectSuccess() {
            this.connectComplete = true;
            this.connectSuccess = true;
            Byte by = this.connectLock;
            synchronized (by) {
                this.connectLock.notifyAll();
            }
        }

        boolean isConnectSuccess() {
            return this.connectSuccess;
        }

        Throwable getConnectException() {
            return this.connectException;
        }

        public void setConnectException(Throwable connectException) {
            this.connectException = connectException;
        }

        Consumer<Channel> getOnConnectSuccessConsumer() {
            return this.onConnectSuccessConsumer;
        }

        void setOnConnectSuccessConsumer(Consumer<Channel> onConnectSuccessConsumer) {
            this.onConnectSuccessConsumer = onConnectSuccessConsumer;
        }

        Consumer<Throwable> getOnConnectFailConsumer() {
            return this.onConnectFailConsumer;
        }

        void setOnConnectFailConsumer(Consumer<Throwable> onConnectFailConsumer) {
            this.onConnectFailConsumer = onConnectFailConsumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isConnectComplete() {
            try {
                Byte by = this.connectLock;
                synchronized (by) {
                    this.connectLock.wait(SocketConnectionManager.this.connectTimeout);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return this.connectComplete;
        }

        AsynchronousSocketChannel getChannel() {
            return this.channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void read(Channel ch) {
            if (!this.readFailed && !this.isReadEOF()) {
                ByteBuffer byteBuffer = this.buffer;
                synchronized (byteBuffer) {
                    this.channel.read(this.buffer, SocketConnectionManager.this.readTimeOut, TimeUnit.MILLISECONDS, ch, this.readCompletionHandler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean refreshBuffer() {
            byte[] ba = null;
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                ba = new byte[this.buffer.position()];
                System.arraycopy(this.buffer.array(), 0, ba, 0, ba.length);
                this.buffer.position(0);
            }
            this.tmpBuff = ByteBuffer.wrap(ba);
            boolean rs = this.readQueue.offer(ByteBuffer.wrap(ba));
            if (rs) {
                this.tmpBuff = null;
                this.updateReadCount(ba.length);
            }
            return rs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateReadCount(Integer result) {
            AsynchronousSocketChannelWrapper asynchronousSocketChannelWrapper = this;
            synchronized (asynchronousSocketChannelWrapper) {
                this.readCount += (long)result.intValue();
            }
        }

        long getReadCount() {
            return this.readCount;
        }

        boolean isReadEOF() {
            return this.readEOF;
        }

        void setReadEOF() {
            this.readEOF = true;
        }

        ReadGuarder commitRead(byte[] result, int off, int length) {
            if (this.readEOF && (this.currentReadBuffer == null || !this.currentReadBuffer.hasRemaining())) {
                throw new AsyncIOException("Have nothing to read!");
            }
            ReadGuarder guarder = new ReadGuarder(result, off, length);
            if (!this.readTaskQueue.offer(guarder)) {
                throw new AsyncIOException("Read task queue full");
            }
            return guarder;
        }

        ReadGuarder commitRead(byte[] result, int off, int length, IntConsumer onSuccess, Consumer<Throwable> onFail) {
            if (this.readEOF && (this.currentReadBuffer == null || !this.currentReadBuffer.hasRemaining())) {
                throw new AsyncIOException("Have nothing to read!");
            }
            ReadGuarder guarder = new ReadGuarder(result, off, length);
            guarder.setOnSuccess(onSuccess);
            guarder.setOnFail(onFail);
            if (!this.readTaskQueue.offer(guarder)) {
                throw new AsyncIOException("Read task queue full");
            }
            return guarder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runReadTask(Channel ch) {
            AsynchronousSocketChannelWrapper asynchronousSocketChannelWrapper = this;
            synchronized (asynchronousSocketChannelWrapper) {
                if (this.readTaskRunning) {
                    return;
                }
                this.readTaskRunning = true;
            }
            try {
                if (this.currentReadTask == null || this.currentReadTask.remaining() <= 0) {
                    this.currentReadTask = this.readTaskQueue.poll();
                }
                while (this.currentReadTask != null && this.currentReadTask.remaining() > 0) {
                    if (this.currentReadBuffer == null || !this.currentReadBuffer.hasRemaining()) {
                        this.currentReadBuffer = this.readQueue.poll();
                    }
                    if (this.currentReadBuffer == null) {
                        if (this.isReadEOF()) {
                            if (this.currentReadTask.getReadCount() <= 0) {
                                this.currentReadTask.setReadCount(-1);
                            }
                            this.currentReadTask.finish();
                            break;
                        }
                        if (this.readFailed) {
                            this.currentReadTask.finish(this.readException);
                            break;
                        }
                        AsynchronousSocketChannelWrapper asynchronousSocketChannelWrapper2 = this;
                        synchronized (asynchronousSocketChannelWrapper2) {
                            this.readTaskRunning = false;
                        }
                        this.read(ch);
                        break;
                    }
                    int _l = Math.min(this.currentReadTask.remaining(), this.currentReadBuffer.remaining());
                    byte[] _b = new byte[_l];
                    this.currentReadBuffer.get(_b, 0, _l);
                    this.currentReadTask.offer(_b, 0, _l);
                    if (this.currentReadTask.remaining() > 0) continue;
                    this.currentReadTask = this.readTaskQueue.poll();
                }
            }
            finally {
                AsynchronousSocketChannelWrapper asynchronousSocketChannelWrapper3 = this;
                synchronized (asynchronousSocketChannelWrapper3) {
                    this.readTaskRunning = false;
                }
                if (this.readTaskQueue.size() > 0) {
                    this.runReadTask(ch);
                }
            }
        }

        public boolean isReadFailed() {
            return this.readFailed;
        }

        public Throwable getReadException() {
            return this.readException;
        }

        public void readFail(Throwable exc) {
            this.readFailed = true;
            this.readException = exc;
        }

        public long getConnectStartTime() {
            return this.connectStartTime;
        }

        public void setConnectStartTime(long connectStartTime) {
            this.connectStartTime = connectStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateWriteCount(Integer result) {
            AsynchronousSocketChannelWrapper asynchronousSocketChannelWrapper = this;
            synchronized (asynchronousSocketChannelWrapper) {
                this.writeCount += (long)result.intValue();
            }
        }

        public long getWriteCount() {
            return this.writeCount;
        }
    }

    private class ReadCompletionHandler
    implements CompletionHandler<Integer, Channel> {
        private ReadCompletionHandler() {
        }

        @Override
        public void completed(Integer result, Channel attachment) {
            AsynchronousSocketChannelWrapper wrapper = SocketConnectionManager.this.getWrapper(attachment);
            if (wrapper != null) {
                if (result >= 0) {
                    if (result > 0) {
                        wrapper.refreshBuffer();
                    }
                } else {
                    wrapper.setReadEOF();
                }
                SocketConnectionManager.this.commitReadTask(attachment);
            }
        }

        @Override
        public void failed(Throwable exc, Channel attachment) {
            AsynchronousSocketChannelWrapper wrapper = SocketConnectionManager.this.getWrapper(attachment);
            if (wrapper != null) {
                wrapper.readFail(exc);
            }
        }
    }
}

