/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.appform.jsonrules.Expression;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.utils.ComparisonUtils;
import java.util.EnumSet;
import java.util.Set;

public abstract class JsonPathBasedExpression
extends Expression {
    private String path;
    private PreOperation<?> preoperation;
    private boolean defaultResult;

    protected JsonPathBasedExpression(ExpressionType type) {
        super(type);
    }

    protected JsonPathBasedExpression(ExpressionType type, String path, boolean defaultResult, PreOperation<?> preoperation) {
        this(type);
        this.path = path;
        this.preoperation = preoperation;
        this.defaultResult = defaultResult;
    }

    @Override
    public final boolean evaluate(ExpressionEvaluationContext context) {
        Object nodeAtPath = null;
        try {
            Object nodeValue = JsonPath.read((String)context.getNode().toString(), (String)this.path, (Predicate[])new Predicate[0]);
            nodeAtPath = nodeValue != null ? ComparisonUtils.mapper.valueToTree(nodeValue) : MissingNode.getInstance();
        }
        catch (PathNotFoundException exception) {
            return this.defaultResult;
        }
        JsonNode evaluatedNode = this.applyPreoperation(context, (JsonNode)nodeAtPath);
        return this.evaluate(context, this.path, evaluatedNode);
    }

    private JsonNode applyPreoperation(ExpressionEvaluationContext globalContext, JsonNode nodeAtPath) {
        if (null == this.preoperation) {
            return nodeAtPath;
        }
        ExpressionEvaluationContext nodeEvaluationContext = globalContext.deepCopy();
        nodeEvaluationContext.setNode(nodeAtPath);
        Object computedValue = this.preoperation.compute(nodeEvaluationContext);
        return ComparisonUtils.mapper.valueToTree(computedValue);
    }

    protected abstract boolean evaluate(ExpressionEvaluationContext var1, String var2, JsonNode var3);

    public String getPath() {
        return this.path;
    }

    public PreOperation<?> getPreoperation() {
        return this.preoperation;
    }

    public boolean isDefaultResult() {
        return this.defaultResult;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPreoperation(PreOperation<?> preoperation) {
        this.preoperation = preoperation;
    }

    public void setDefaultResult(boolean defaultResult) {
        this.defaultResult = defaultResult;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonPathBasedExpression)) {
            return false;
        }
        JsonPathBasedExpression other = (JsonPathBasedExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        PreOperation<?> this$preoperation = this.getPreoperation();
        PreOperation<?> other$preoperation = other.getPreoperation();
        if (this$preoperation == null ? other$preoperation != null : !((Object)this$preoperation).equals(other$preoperation)) {
            return false;
        }
        return this.isDefaultResult() == other.isDefaultResult();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JsonPathBasedExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        PreOperation<?> $preoperation = this.getPreoperation();
        result = result * 59 + ($preoperation == null ? 43 : ((Object)$preoperation).hashCode());
        result = result * 59 + (this.isDefaultResult() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "JsonPathBasedExpression(super=" + super.toString() + ", path=" + this.getPath() + ", preoperation=" + this.getPreoperation() + ", defaultResult=" + this.isDefaultResult() + ")";
    }

    static {
        Configuration.setDefaults((Configuration.Defaults)new JacksonConfiguration());
    }

    private static final class JacksonConfiguration
    implements Configuration.Defaults {
        private final JsonProvider jsonProvider = new JacksonJsonProvider();
        private final MappingProvider mappingProvider = new JacksonMappingProvider();

        private JacksonConfiguration() {
        }

        public JsonProvider jsonProvider() {
            return this.jsonProvider;
        }

        public MappingProvider mappingProvider() {
            return this.mappingProvider;
        }

        public Set<Option> options() {
            return EnumSet.noneOf(Option.class);
        }
    }
}

