/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.string;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.expressions.preoperation.PreOperationType;

public class SubStringOperation
extends PreOperation<String> {
    private static final String EMPTY_STRING = "";
    private int beginIndex;
    private int endIndex;
    private boolean suppressExceptions;

    public SubStringOperation() {
        super(PreOperationType.sub_str);
    }

    public SubStringOperation(int beginIndex, int endIndex, boolean suppressExceptions) {
        this();
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.suppressExceptions = suppressExceptions;
    }

    @Override
    public String compute(ExpressionEvaluationContext context) {
        try {
            JsonNode node = context.getNode();
            if (node.isTextual()) {
                String nodeText = node.asText(EMPTY_STRING);
                if (this.beginIndex >= 0 && this.beginIndex < nodeText.length()) {
                    if (this.endIndex == -1) {
                        return nodeText.substring(this.beginIndex);
                    }
                    if (this.endIndex >= 0 && this.endIndex >= this.beginIndex && this.endIndex <= nodeText.length()) {
                        return nodeText.substring(this.beginIndex, this.endIndex);
                    }
                }
            }
            if (this.suppressExceptions) {
                return EMPTY_STRING;
            }
            throw new IllegalArgumentException("Sub-String operation is not supported");
        }
        catch (Exception e) {
            if (this.suppressExceptions) {
                return EMPTY_STRING;
            }
            throw e;
        }
    }

    private static int $default$beginIndex() {
        return -1;
    }

    private static int $default$endIndex() {
        return -1;
    }

    public static SubStringOperationBuilder builder() {
        return new SubStringOperationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubStringOperation)) {
            return false;
        }
        SubStringOperation other = (SubStringOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.beginIndex != other.beginIndex) {
            return false;
        }
        if (this.endIndex != other.endIndex) {
            return false;
        }
        return this.suppressExceptions == other.suppressExceptions;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubStringOperation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.beginIndex;
        result = result * 59 + this.endIndex;
        result = result * 59 + (this.suppressExceptions ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "SubStringOperation(super=" + super.toString() + ", beginIndex=" + this.beginIndex + ", endIndex=" + this.endIndex + ", suppressExceptions=" + this.suppressExceptions + ")";
    }

    public static class SubStringOperationBuilder {
        private boolean beginIndex$set;
        private int beginIndex;
        private boolean endIndex$set;
        private int endIndex;
        private boolean suppressExceptions;

        SubStringOperationBuilder() {
        }

        public SubStringOperationBuilder beginIndex(int beginIndex) {
            this.beginIndex = beginIndex;
            this.beginIndex$set = true;
            return this;
        }

        public SubStringOperationBuilder endIndex(int endIndex) {
            this.endIndex = endIndex;
            this.endIndex$set = true;
            return this;
        }

        public SubStringOperationBuilder suppressExceptions(boolean suppressExceptions) {
            this.suppressExceptions = suppressExceptions;
            return this;
        }

        public SubStringOperation build() {
            return new SubStringOperation(this.beginIndex$set ? this.beginIndex : SubStringOperation.$default$beginIndex(), this.endIndex$set ? this.endIndex : SubStringOperation.$default$endIndex(), this.suppressExceptions);
        }

        public String toString() {
            return "SubStringOperation.SubStringOperationBuilder(beginIndex=" + this.beginIndex + ", endIndex=" + this.endIndex + ", suppressExceptions=" + this.suppressExceptions + ")";
        }
    }
}

