/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.equality;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.utils.ComparisonUtils;

public class NotEqualsExpression
extends JsonPathBasedExpression {
    private Object value;
    private boolean extractValueFromPath;

    public NotEqualsExpression() {
        super(ExpressionType.not_equals);
        this.setDefaultResult(true);
    }

    public NotEqualsExpression(String path, Object value, boolean extractValueFromPath, Boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.not_equals, path, ComparisonUtils.getDefaultResult(defaultResult, true), preoperation);
        this.value = value;
        this.extractValueFromPath = extractValueFromPath;
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        if (this.extractValueFromPath) {
            return ComparisonUtils.compareForNotEquals(context, evaluatedNode, this.value);
        }
        return this.value == null || ComparisonUtils.isNodeMissingOrNull(evaluatedNode) || ComparisonUtils.compare(evaluatedNode, this.value) != 0;
    }

    public static NotEqualsExpressionBuilder builder() {
        return new NotEqualsExpressionBuilder();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isExtractValueFromPath() {
        return this.extractValueFromPath;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setExtractValueFromPath(boolean extractValueFromPath) {
        this.extractValueFromPath = extractValueFromPath;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotEqualsExpression)) {
            return false;
        }
        NotEqualsExpression other = (NotEqualsExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.isExtractValueFromPath() == other.isExtractValueFromPath();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NotEqualsExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isExtractValueFromPath() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "NotEqualsExpression(super=" + super.toString() + ", value=" + this.getValue() + ", extractValueFromPath=" + this.isExtractValueFromPath() + ")";
    }

    public static class NotEqualsExpressionBuilder {
        private String path;
        private Object value;
        private boolean extractValueFromPath;
        private Boolean defaultResult;
        private PreOperation<?> preoperation;

        NotEqualsExpressionBuilder() {
        }

        public NotEqualsExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public NotEqualsExpressionBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public NotEqualsExpressionBuilder extractValueFromPath(boolean extractValueFromPath) {
            this.extractValueFromPath = extractValueFromPath;
            return this;
        }

        public NotEqualsExpressionBuilder defaultResult(Boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public NotEqualsExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public NotEqualsExpression build() {
            return new NotEqualsExpression(this.path, this.value, this.extractValueFromPath, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "NotEqualsExpression.NotEqualsExpressionBuilder(path=" + this.path + ", value=" + this.value + ", extractValueFromPath=" + this.extractValueFromPath + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

