/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.array;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.utils.ComparisonUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class CollectionJsonPathBasedExpression
extends JsonPathBasedExpression {
    private Set<Object> values;
    private boolean extractValues;
    private String valuesPath;

    protected CollectionJsonPathBasedExpression(ExpressionType type) {
        super(type);
    }

    protected CollectionJsonPathBasedExpression(ExpressionType type, String path, Set<Object> values, boolean extractValues, String valuesPath, boolean defaultResult, PreOperation<?> preoperation) {
        super(type, path, defaultResult, preoperation);
        this.values = values;
        this.extractValues = extractValues;
        this.valuesPath = valuesPath;
    }

    @Override
    protected final boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        if (this.extractValues) {
            MissingNode jsonNode = MissingNode.getInstance();
            try {
                jsonNode = ComparisonUtils.mapper.valueToTree(JsonPath.read((String)context.getNode().toString(), (String)String.valueOf(this.valuesPath), (Predicate[])new Predicate[0]));
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
            if (jsonNode == null || !jsonNode.isArray()) {
                return false;
            }
            HashSet<Object> extractedPathVaues = new HashSet<Object>((Collection)JsonPath.read((String)jsonNode.toString(), (String)"$", (Predicate[])new Predicate[0]));
            return this.evaluate(evaluatedNode, extractedPathVaues);
        }
        if (null == this.values || this.values.isEmpty()) {
            return false;
        }
        return this.evaluate(evaluatedNode, this.values);
    }

    protected abstract boolean evaluate(JsonNode var1, Set<Object> var2);

    public Set<Object> getValues() {
        return this.values;
    }

    public boolean isExtractValues() {
        return this.extractValues;
    }

    public String getValuesPath() {
        return this.valuesPath;
    }

    public void setValues(Set<Object> values) {
        this.values = values;
    }

    public void setExtractValues(boolean extractValues) {
        this.extractValues = extractValues;
    }

    public void setValuesPath(String valuesPath) {
        this.valuesPath = valuesPath;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionJsonPathBasedExpression)) {
            return false;
        }
        CollectionJsonPathBasedExpression other = (CollectionJsonPathBasedExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<Object> this$values = this.getValues();
        Set<Object> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        if (this.isExtractValues() != other.isExtractValues()) {
            return false;
        }
        String this$valuesPath = this.getValuesPath();
        String other$valuesPath = other.getValuesPath();
        return !(this$valuesPath == null ? other$valuesPath != null : !this$valuesPath.equals(other$valuesPath));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CollectionJsonPathBasedExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Set<Object> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        result = result * 59 + (this.isExtractValues() ? 79 : 97);
        String $valuesPath = this.getValuesPath();
        result = result * 59 + ($valuesPath == null ? 43 : $valuesPath.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CollectionJsonPathBasedExpression(super=" + super.toString() + ", values=" + this.getValues() + ", extractValues=" + this.isExtractValues() + ", valuesPath=" + this.getValuesPath() + ")";
    }
}

