/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.date;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.expressions.preoperation.PreOperationType;

public abstract class CalendarOperation
extends PreOperation<Number> {
    private String operand;
    private String zoneOffSet;

    protected CalendarOperation(PreOperationType type) {
        super(type);
    }

    protected CalendarOperation(PreOperationType type, String operand, String zoneOffSet) {
        this(type);
        this.operand = operand;
        this.zoneOffSet = zoneOffSet;
    }

    public Number compute(JsonNode evaluatedNode) {
        if (this.operand != null && (evaluatedNode.isNumber() || evaluatedNode.isTextual())) {
            return this.compute(evaluatedNode, this.operand, this.zoneOffSet);
        }
        throw new IllegalArgumentException("Operands do not represent valid values");
    }

    @Override
    public Number compute(ExpressionEvaluationContext context) {
        JsonNode node = context.getNode();
        return this.compute(node);
    }

    protected abstract Number compute(JsonNode var1, String var2, String var3);

    public String getOperand() {
        return this.operand;
    }

    public String getZoneOffSet() {
        return this.zoneOffSet;
    }

    public void setOperand(String operand) {
        this.operand = operand;
    }

    public void setZoneOffSet(String zoneOffSet) {
        this.zoneOffSet = zoneOffSet;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarOperation)) {
            return false;
        }
        CalendarOperation other = (CalendarOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$operand = this.getOperand();
        String other$operand = other.getOperand();
        if (this$operand == null ? other$operand != null : !this$operand.equals(other$operand)) {
            return false;
        }
        String this$zoneOffSet = this.getZoneOffSet();
        String other$zoneOffSet = other.getZoneOffSet();
        return !(this$zoneOffSet == null ? other$zoneOffSet != null : !this$zoneOffSet.equals(other$zoneOffSet));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CalendarOperation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $operand = this.getOperand();
        result = result * 59 + ($operand == null ? 43 : $operand.hashCode());
        String $zoneOffSet = this.getZoneOffSet();
        result = result * 59 + ($zoneOffSet == null ? 43 : $zoneOffSet.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CalendarOperation(super=" + super.toString() + ", operand=" + this.getOperand() + ", zoneOffSet=" + this.getZoneOffSet() + ")";
    }
}

