/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.string;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;

public abstract class StringJsonPathBasedExpression
extends JsonPathBasedExpression {
    private String value;
    private boolean ignoreCase;
    private boolean extractValueFromPath;

    protected StringJsonPathBasedExpression(ExpressionType type) {
        super(type);
    }

    protected StringJsonPathBasedExpression(ExpressionType type, String path, String value, boolean ignoreCase, boolean extractValueFromPath, boolean defaultResult, PreOperation<?> preoperation) {
        super(type, path, defaultResult, preoperation);
        this.value = value;
        this.ignoreCase = ignoreCase;
        this.extractValueFromPath = extractValueFromPath;
    }

    @Override
    protected final boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        if (!evaluatedNode.isTextual()) {
            return false;
        }
        if (this.extractValueFromPath) {
            String extractedValue = context.getNode().at(this.value).asText();
            return this.evaluate(evaluatedNode.asText(), extractedValue, this.ignoreCase);
        }
        return this.evaluate(evaluatedNode.asText(), this.value, this.ignoreCase);
    }

    protected abstract boolean evaluate(String var1, String var2, boolean var3);

    public String getValue() {
        return this.value;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isExtractValueFromPath() {
        return this.extractValueFromPath;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setExtractValueFromPath(boolean extractValueFromPath) {
        this.extractValueFromPath = extractValueFromPath;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringJsonPathBasedExpression)) {
            return false;
        }
        StringJsonPathBasedExpression other = (StringJsonPathBasedExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        if (this.isIgnoreCase() != other.isIgnoreCase()) {
            return false;
        }
        return this.isExtractValueFromPath() == other.isExtractValueFromPath();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StringJsonPathBasedExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isIgnoreCase() ? 79 : 97);
        result = result * 59 + (this.isExtractValueFromPath() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "StringJsonPathBasedExpression(super=" + super.toString() + ", value=" + this.getValue() + ", ignoreCase=" + this.isIgnoreCase() + ", extractValueFromPath=" + this.isExtractValueFromPath() + ")";
    }
}

