/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.utils;

import com.fasterxml.jackson.databind.JsonNode;

public interface ComparisonUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int compare(JsonNode evaluatedNode, Object value) {
        int comparisonResult = 0;
        if (evaluatedNode.isNumber()) {
            if (!Number.class.isAssignableFrom(value.getClass())) throw new IllegalArgumentException("Type mismatch between operator and operand");
            Number nValue = (Number)value;
            if (evaluatedNode.isIntegralNumber()) {
                return Long.compare(evaluatedNode.asLong(), nValue.longValue());
            }
            if (!evaluatedNode.isFloatingPointNumber()) return comparisonResult;
            return Double.compare(evaluatedNode.asDouble(), nValue.doubleValue());
        }
        if (evaluatedNode.isBoolean()) {
            if (!Boolean.class.isAssignableFrom(value.getClass())) throw new IllegalArgumentException("Type mismatch between operator and operand");
            Boolean bValue = Boolean.parseBoolean(value.toString());
            return Boolean.compare(evaluatedNode.asBoolean(), bValue);
        }
        if (evaluatedNode.isTextual()) {
            if (!String.class.isAssignableFrom(value.getClass())) throw new IllegalArgumentException("Type mismatch between operator and operand");
            return evaluatedNode.asText().compareTo(String.valueOf(value));
        }
        if (!evaluatedNode.isObject()) return comparisonResult;
        throw new IllegalArgumentException("Object comparisons not supported");
    }

    public static boolean isNodeMissingOrNull(JsonNode node) {
        return node.isMissingNode() || node.isNull();
    }

    public static boolean getDefaultResult(Boolean defaultResult, boolean resultIfNull) {
        if (null == defaultResult) {
            return resultIfNull;
        }
        return defaultResult;
    }
}

