/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.numeric;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.expressions.preoperation.PreOperationType;

public abstract class NumericPreOperation
extends PreOperation<Number> {
    private Number operand;

    public NumericPreOperation(PreOperationType type) {
        super(type);
    }

    public NumericPreOperation(PreOperationType type, Number operand) {
        this(type);
        this.operand = operand;
    }

    public Number compute(JsonNode evaluatedNode) {
        if (evaluatedNode.isNumber()) {
            if (evaluatedNode.isIntegralNumber()) {
                return this.compute(evaluatedNode.asLong(), this.operand.longValue());
            }
            return this.compute(evaluatedNode.asDouble(), this.operand.doubleValue());
        }
        throw new IllegalArgumentException("Non numeric operations are not supported");
    }

    @Override
    public Number compute(ExpressionEvaluationContext context) {
        JsonNode node = context.getNode();
        return this.compute(node);
    }

    public abstract long compute(long var1, long var3);

    public abstract double compute(double var1, double var3);

    public Number getOperand() {
        return this.operand;
    }

    public void setOperand(Number operand) {
        this.operand = operand;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumericPreOperation)) {
            return false;
        }
        NumericPreOperation other = (NumericPreOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Number this$operand = this.getOperand();
        Number other$operand = other.getOperand();
        return !(this$operand == null ? other$operand != null : !this$operand.equals(other$operand));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NumericPreOperation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Number $operand = this.getOperand();
        result = result * 59 + ($operand == null ? 43 : $operand.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "NumericPreOperation(super=" + super.toString() + ", operand=" + this.getOperand() + ")";
    }
}

