/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.date;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.expressions.preoperation.PreOperationType;
import io.appform.jsonrules.expressions.preoperation.date.CalendarOperation;
import io.appform.jsonrules.utils.PreOperationUtils;
import java.time.OffsetDateTime;

public class DateTimeOperation
extends CalendarOperation {
    protected DateTimeOperation() {
        super(PreOperationType.date_time);
    }

    public DateTimeOperation(String operand, String zoneOffSet) {
        super(PreOperationType.date_time, operand, zoneOffSet);
    }

    @Override
    public Number compute(JsonNode evaluatedNode, String operand, String zoneOffset) {
        try {
            OffsetDateTime dateTime = PreOperationUtils.getDateTime(evaluatedNode.asText(), zoneOffset);
            return PreOperationUtils.getFromDateTime(dateTime, operand);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Operand doesnot represent a valid date");
        }
    }

    public static DateTimeOperationBuilder builder() {
        return new DateTimeOperationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateTimeOperation)) {
            return false;
        }
        DateTimeOperation other = (DateTimeOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DateTimeOperation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "DateTimeOperation(super=" + super.toString() + ")";
    }

    public static class DateTimeOperationBuilder {
        private String operand;
        private String zoneOffSet;

        DateTimeOperationBuilder() {
        }

        public DateTimeOperationBuilder operand(String operand) {
            this.operand = operand;
            return this;
        }

        public DateTimeOperationBuilder zoneOffSet(String zoneOffSet) {
            this.zoneOffSet = zoneOffSet;
            return this;
        }

        public DateTimeOperation build() {
            return new DateTimeOperation(this.operand, this.zoneOffSet);
        }

        public String toString() {
            return "DateTimeOperation.DateTimeOperationBuilder(operand=" + this.operand + ", zoneOffSet=" + this.zoneOffSet + ")";
        }
    }
}

