/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.equality;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;
import io.appform.jsonrules.expressions.preoperation.PreOperation;
import io.appform.jsonrules.utils.ComparisonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class NotInExpression
extends JsonPathBasedExpression {
    private List<Object> values;

    public NotInExpression() {
        super(ExpressionType.not_in);
    }

    public NotInExpression(String path, List<Object> values, Boolean defaultResult, PreOperation<?> preoperation) {
        super(ExpressionType.not_in, path, ComparisonUtils.getDefaultResult(defaultResult, true), preoperation);
        this.values = values;
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        return null != this.values && (ComparisonUtils.isNodeMissingOrNull(evaluatedNode) || this.values.stream().allMatch(value -> ComparisonUtils.compare(evaluatedNode, value) != 0));
    }

    public static NotInExpressionBuilder builder() {
        return new NotInExpressionBuilder();
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotInExpression)) {
            return false;
        }
        NotInExpression other = (NotInExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Object> this$values = this.getValues();
        List<Object> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NotInExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<Object> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "NotInExpression(super=" + super.toString() + ", values=" + this.getValues() + ")";
    }

    public static class NotInExpressionBuilder {
        private String path;
        private ArrayList<Object> values;
        private Boolean defaultResult;
        private PreOperation<?> preoperation;

        NotInExpressionBuilder() {
        }

        public NotInExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public NotInExpressionBuilder value(Object value) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(value);
            return this;
        }

        public NotInExpressionBuilder values(Collection<? extends Object> values) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.addAll(values);
            return this;
        }

        public NotInExpressionBuilder clearValues() {
            if (this.values != null) {
                this.values.clear();
            }
            return this;
        }

        public NotInExpressionBuilder defaultResult(Boolean defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public NotInExpressionBuilder preoperation(PreOperation<?> preoperation) {
            this.preoperation = preoperation;
            return this;
        }

        public NotInExpression build() {
            List<Object> values;
            switch (this.values == null ? 0 : this.values.size()) {
                case 0: {
                    values = Collections.emptyList();
                    break;
                }
                case 1: {
                    values = Collections.singletonList(this.values.get(0));
                    break;
                }
                default: {
                    values = Collections.unmodifiableList(new ArrayList<Object>(this.values));
                }
            }
            return new NotInExpression(this.path, values, this.defaultResult, this.preoperation);
        }

        public String toString() {
            return "NotInExpression.NotInExpressionBuilder(path=" + this.path + ", values=" + this.values + ", defaultResult=" + this.defaultResult + ", preoperation=" + this.preoperation + ")";
        }
    }
}

