/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.preoperation.date;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.expressions.preoperation.PreOperationType;
import io.appform.jsonrules.expressions.preoperation.date.CalendarOperation;
import io.appform.jsonrules.utils.PreOperationUtils;
import java.time.OffsetDateTime;

public class EpochOperation
extends CalendarOperation {
    public EpochOperation() {
        super(PreOperationType.epoch);
    }

    public EpochOperation(String operand, String zoneOffSet) {
        super(PreOperationType.epoch, operand, zoneOffSet);
    }

    @Override
    public Number compute(JsonNode evaluatedNode, String operand, String zoneOffSet) {
        OffsetDateTime dateTime = PreOperationUtils.getDateTime(evaluatedNode.asLong(), zoneOffSet);
        return PreOperationUtils.getFromDateTime(dateTime, operand);
    }

    public static EpochOperationBuilder builder() {
        return new EpochOperationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EpochOperation)) {
            return false;
        }
        EpochOperation other = (EpochOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EpochOperation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "EpochOperation(super=" + super.toString() + ")";
    }

    public static class EpochOperationBuilder {
        private String operand;
        private String zoneOffSet;

        EpochOperationBuilder() {
        }

        public EpochOperationBuilder operand(String operand) {
            this.operand = operand;
            return this;
        }

        public EpochOperationBuilder zoneOffSet(String zoneOffSet) {
            this.zoneOffSet = zoneOffSet;
            return this;
        }

        public EpochOperation build() {
            return new EpochOperation(this.operand, this.zoneOffSet);
        }

        public String toString() {
            return "EpochOperation.EpochOperationBuilder(operand=" + this.operand + ", zoneOffSet=" + this.zoneOffSet + ")";
        }
    }
}

