/*
 * Decompiled with CFR 0.152.
 */
package io.appform.jsonrules.expressions.string;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.jsonrules.ExpressionEvaluationContext;
import io.appform.jsonrules.ExpressionType;
import io.appform.jsonrules.expressions.JsonPathBasedExpression;

public class NotEmptyExpression
extends JsonPathBasedExpression {
    public NotEmptyExpression() {
        super(ExpressionType.not_empty);
    }

    public NotEmptyExpression(String path) {
        super(ExpressionType.not_empty, path);
    }

    @Override
    protected boolean evaluate(ExpressionEvaluationContext context, String path, JsonNode evaluatedNode) {
        if (!evaluatedNode.isTextual()) {
            return false;
        }
        String data = evaluatedNode.asText();
        return null != data && !data.isEmpty();
    }

    public static NotEmptyExpressionBuilder builder() {
        return new NotEmptyExpressionBuilder();
    }

    public static class NotEmptyExpressionBuilder {
        private String path;

        NotEmptyExpressionBuilder() {
        }

        public NotEmptyExpressionBuilder path(String path) {
            this.path = path;
            return this;
        }

        public NotEmptyExpression build() {
            return new NotEmptyExpression(this.path);
        }

        public String toString() {
            return "NotEmptyExpression.NotEmptyExpressionBuilder(path=" + this.path + ")";
        }
    }
}

