/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.lang;

import com.fasterxml.jackson.databind.JsonNode;
import io.appform.hope.core.Evaluatable;
import io.appform.hope.core.exceptions.errorstrategy.DefaultErrorHandlingStrategy;
import io.appform.hope.core.exceptions.errorstrategy.ErrorHandlingStrategy;
import io.appform.hope.core.exceptions.impl.HopeExpressionParserError;
import io.appform.hope.core.functions.FunctionRegistry;
import io.appform.hope.core.functions.HopeFunction;
import io.appform.hope.core.visitors.Evaluator;
import io.appform.hope.lang.parser.HopeParser;
import io.appform.hope.lang.parser.ParseException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class HopeLangEngine {
    private final FunctionRegistry functionRegistry;
    private final ErrorHandlingStrategy errorHandlingStrategy;

    private HopeLangEngine(FunctionRegistry functionRegistry, ErrorHandlingStrategy errorHandlingStrategy) {
        this.functionRegistry = functionRegistry;
        this.errorHandlingStrategy = errorHandlingStrategy;
    }

    public boolean evaluate(String hopeLangExpression, JsonNode root) {
        Evaluatable evaluatable = this.parse(hopeLangExpression);
        return this.evaluate(evaluatable, root);
    }

    public Evaluatable parse(String hopeLangExpression) throws HopeExpressionParserError {
        try {
            return new HopeParser(new StringReader(hopeLangExpression)).parse(this.functionRegistry);
        }
        catch (ParseException e) {
            throw new HopeExpressionParserError(e.getMessage());
        }
    }

    public boolean evaluate(Evaluatable rule, JsonNode node) {
        return new Evaluator(this.errorHandlingStrategy).evaluate(rule, node);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<String> userPackages = new ArrayList<String>();
        private final FunctionRegistry functionRegistry = new FunctionRegistry();
        private ErrorHandlingStrategy errorHandlingStrategy = new DefaultErrorHandlingStrategy();

        private Builder() {
        }

        public Builder addPackage(String userPackage) {
            this.userPackages.add(userPackage);
            return this;
        }

        public Builder registerFunction(Class<? extends HopeFunction> hopeFunctionClass) {
            this.functionRegistry.register(hopeFunctionClass);
            return this;
        }

        public Builder errorHandlingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
            this.errorHandlingStrategy = errorHandlingStrategy;
            return this;
        }

        public HopeLangEngine build() {
            this.functionRegistry.discover(this.userPackages);
            return new HopeLangEngine(this.functionRegistry, this.errorHandlingStrategy);
        }
    }
}

