/*
 * Copyright 2019. Santanu Sinha
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and limitations
 * under the License.
 */

package io.appform.hope.core.exceptions.impl;

import io.appform.hope.core.exceptions.HopeException;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * This error is thrown when value is missing in provided json for a path present in expression.
 * This is thrown by {@link io.appform.hope.core.exceptions.errorstrategy.DefaultErrorHandlingStrategy#handleMissingValue(String, Object)}
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class HopeMissingValueError extends HopeException {
    private final String path;

    public HopeMissingValueError(String path) {
        super("Missing value at path: " + path);
        this.path = path;
    }
}
