/*
 * Copyright 2019. Santanu Sinha
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and limitations
 * under the License.
 */

package io.appform.hope.core.exceptions.errorstrategy;

import io.appform.hope.core.exceptions.impl.HopeIllegalEvaluationError;
import io.appform.hope.core.exceptions.impl.HopeMissingValueError;
import io.appform.hope.core.exceptions.impl.HopeTypeMismatchError;

/**
 * Default {@link ErrorHandlingStrategy}. This will throw exceptions in case of errors.
 */
public class DefaultErrorHandlingStrategy implements ErrorHandlingStrategy {
    /**
     * {@inheritDoc}
     */
    @Override
    public <T> T handleMissingValue(String path, T defaultValue) {
        throw new HopeMissingValueError(path);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public <T> T handleTypeMismatch(String path, String expected, String actual, T defaultValue) {
        throw new HopeTypeMismatchError(path, expected, actual);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public <T> T handleIllegalEval(String message, T defaultValue) {
        throw new HopeIllegalEvaluationError(message);
    }
}
